#include <iostream>

#include "CommandlineOptions.hh"

#include "Symmetry.hh"
#include "PointConfiguration.hh"

int main (const int argc, const char** argv) {
  using namespace topcom;

  CommandlineOptions::init(argc, argv);
  MessageStreams::forced() << std::endl;
  MessageStreams::forced() << "------------------------------------------------------------------\n";
  MessageStreams::forced() << " computing a Gale transformation of a point configuration \n";
  MessageStreams::forced() << " TOPCOM client: " << CommandlineOptions::client() << '\n';
  MessageStreams::forced() << "------------------------------------------------------------------\n";
  MessageStreams::forced() << std::endl;
  PointConfiguration points;
  if (points.read(std::cin)) {
    MessageStreams::verbose() << "read " << points.no() << " points" << std::endl;
    MessageStreams::debug() << points << std::endl;
    SymmetryGroup symmetries(points.no());
    if (!CommandlineOptions::ignore_symmetries()) {
      if (symmetries.read_generators(std::cin)) {
	MessageStreams::verbose() << symmetries.generators().size() + 1 << " symmetry generators in total." << std::endl;
	MessageStreams::debug() << "symmetry generators:" << std::endl;
	symmetries.write_generators(MessageStreams::debug());
	MessageStreams::debug() << std::endl;
      }
    }
    else {
      if (CommandlineOptions::verbose()) {
	std::cerr << "no valid symmetry generators found." << std::endl;
      }
    }
    MessageStreams::result() << points.gale() << std::endl;
    symmetries.write_sorted_generators(MessageStreams::result());
    MessageStreams::result() << std::endl;
    return 0;
  }
  else {
    return 1;
  }
}

// eof points2gale.cc
