/*===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

#ifndef _h_sra_sort_
#define _h_sra_sort_

#ifndef _h_sra_sort_defs_
#include "sort-defs.h"
#endif

#ifndef _h_kfs_defs_
#include <kfs/defs.h>
#endif

#ifndef _h_kdb_column_
#include <kdb/column.h>
#endif


#define NEW_TYPES 1

/*--------------------------------------------------------------------------
 * forwards
 */
struct DbPair;
struct TablePair;


/*--------------------------------------------------------------------------
 * Selection
 *  input selection criteria
 */
typedef struct Selection Selection;
struct Selection
{
    int dummy;
};

/*--------------------------------------------------------------------------
 * Tool
 *  parameter block generated by KMain
 */
typedef struct Tool Tool;
struct Tool
{
    /* input selection */
    const Selection *sel;

    /* directory for temporary files */
    const char *tmpdir;

    /* directory for mmap page files */
    const char *mmapdir;

    /* source object path */
    const char *src_path;

    /* destination object path */
    const char *dst_path;

    /* buffer size for id map files */
    size_t map_file_bsize;
    size_t map_file_random_bsize;

    /* the number of ids to gather at a time */
    size_t max_ref_idx_ids;
    size_t max_large_idx_ids;
    size_t max_poslen_ids;
    size_t max_idx_ids;
    size_t min_idx_ids;

    /* the number of missing SEQUENCE ids to gather at a time */
    size_t max_missing_ids;

    /* pid of tool */
    int pid;

    /* db create mode */
    struct
    {
        KCreateMode cmode;
    } db;

    /* tbl create mode */
    struct
    {
        KCreateMode cmode;
    } tbl;

    /* column blob checksum mode */
    struct
    {
        size_t pgsize;
        KCreateMode cmode;
        KChecksum checksum;
    } col;

    /* ignore failure on multiple sorts */
    bool ignore;

    /* force overwrite */
    bool force;

    /* write new=>old mappings
       not normally needed */
    bool write_new_to_old;

    /* whether to apply a sort on old-id
       before writing old=>new mapping or
       to let pagefile handle it */
    bool sort_before_old2new;

    /* normally remove idx files right away
       but if they are being debugged... */
    bool unlink_idx_files;

    /* perform consistency check on index */
    bool idx_consistency_check;
};


/*--------------------------------------------------------------------------
 * TypeParams
 *  object type params
 */
typedef struct TypeParams TypeParams;
struct TypeParams
{
    char src_type [ 256 ];
    char dst_type [ 256 ];
    char view_type [ 256 ];
};


/*--------------------------------------------------------------------------
 * sra-sort functions
 */

/* run
 *  called from KMain
 *  determines the type of object being copied/sorted
 *  opens input object
 *  dispatches to the appropriate handler
 */
void run ( const ctx_t *ctx );

rc_t copy_stats_metadata( const char * src_path, const char * dst_path );
    
#endif
