// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use gdk;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::GString;
use glib::StaticType;
use glib::ToValue;
use glib::Value;
use glib_sys;
use gobject_sys;
use gtk_sys;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem;
use std::mem::transmute;
use Buildable;
use CellArea;
use CellLayout;
use CellRenderer;
use SortType;
use TreeIter;
use TreeModel;
use TreeViewColumnSizing;
use Widget;

glib_wrapper! {
    pub struct TreeViewColumn(Object<gtk_sys::GtkTreeViewColumn, gtk_sys::GtkTreeViewColumnClass, TreeViewColumnClass>) @implements Buildable, CellLayout;

    match fn {
        get_type => || gtk_sys::gtk_tree_view_column_get_type(),
    }
}

impl TreeViewColumn {
    pub fn new() -> TreeViewColumn {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(gtk_sys::gtk_tree_view_column_new()) }
    }

    pub fn new_with_area<P: IsA<CellArea>>(area: &P) -> TreeViewColumn {
        skip_assert_initialized!();
        unsafe {
            from_glib_none(gtk_sys::gtk_tree_view_column_new_with_area(
                area.as_ref().to_glib_none().0,
            ))
        }
    }

    //pub fn new_with_attributes<P: IsA<CellRenderer>>(title: &str, cell: &P, : /*Unknown conversion*//*Unimplemented*/Fundamental: VarArgs) -> TreeViewColumn {
    //    unsafe { TODO: call gtk_sys:gtk_tree_view_column_new_with_attributes() }
    //}
}

impl Default for TreeViewColumn {
    fn default() -> Self {
        Self::new()
    }
}

pub struct TreeViewColumnBuilder {
    alignment: Option<f32>,
    cell_area: Option<CellArea>,
    clickable: Option<bool>,
    expand: Option<bool>,
    fixed_width: Option<i32>,
    max_width: Option<i32>,
    min_width: Option<i32>,
    reorderable: Option<bool>,
    resizable: Option<bool>,
    sizing: Option<TreeViewColumnSizing>,
    sort_column_id: Option<i32>,
    sort_indicator: Option<bool>,
    sort_order: Option<SortType>,
    spacing: Option<i32>,
    title: Option<String>,
    visible: Option<bool>,
    widget: Option<Widget>,
}

impl TreeViewColumnBuilder {
    pub fn new() -> Self {
        Self {
            alignment: None,
            cell_area: None,
            clickable: None,
            expand: None,
            fixed_width: None,
            max_width: None,
            min_width: None,
            reorderable: None,
            resizable: None,
            sizing: None,
            sort_column_id: None,
            sort_indicator: None,
            sort_order: None,
            spacing: None,
            title: None,
            visible: None,
            widget: None,
        }
    }

    pub fn build(self) -> TreeViewColumn {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref alignment) = self.alignment {
            properties.push(("alignment", alignment));
        }
        if let Some(ref cell_area) = self.cell_area {
            properties.push(("cell-area", cell_area));
        }
        if let Some(ref clickable) = self.clickable {
            properties.push(("clickable", clickable));
        }
        if let Some(ref expand) = self.expand {
            properties.push(("expand", expand));
        }
        if let Some(ref fixed_width) = self.fixed_width {
            properties.push(("fixed-width", fixed_width));
        }
        if let Some(ref max_width) = self.max_width {
            properties.push(("max-width", max_width));
        }
        if let Some(ref min_width) = self.min_width {
            properties.push(("min-width", min_width));
        }
        if let Some(ref reorderable) = self.reorderable {
            properties.push(("reorderable", reorderable));
        }
        if let Some(ref resizable) = self.resizable {
            properties.push(("resizable", resizable));
        }
        if let Some(ref sizing) = self.sizing {
            properties.push(("sizing", sizing));
        }
        if let Some(ref sort_column_id) = self.sort_column_id {
            properties.push(("sort-column-id", sort_column_id));
        }
        if let Some(ref sort_indicator) = self.sort_indicator {
            properties.push(("sort-indicator", sort_indicator));
        }
        if let Some(ref sort_order) = self.sort_order {
            properties.push(("sort-order", sort_order));
        }
        if let Some(ref spacing) = self.spacing {
            properties.push(("spacing", spacing));
        }
        if let Some(ref title) = self.title {
            properties.push(("title", title));
        }
        if let Some(ref visible) = self.visible {
            properties.push(("visible", visible));
        }
        if let Some(ref widget) = self.widget {
            properties.push(("widget", widget));
        }
        glib::Object::new(TreeViewColumn::static_type(), &properties)
            .expect("object new")
            .downcast()
            .expect("downcast")
    }

    pub fn alignment(mut self, alignment: f32) -> Self {
        self.alignment = Some(alignment);
        self
    }

    pub fn cell_area(mut self, cell_area: &CellArea) -> Self {
        self.cell_area = Some(cell_area.clone());
        self
    }

    pub fn clickable(mut self, clickable: bool) -> Self {
        self.clickable = Some(clickable);
        self
    }

    pub fn expand(mut self, expand: bool) -> Self {
        self.expand = Some(expand);
        self
    }

    pub fn fixed_width(mut self, fixed_width: i32) -> Self {
        self.fixed_width = Some(fixed_width);
        self
    }

    pub fn max_width(mut self, max_width: i32) -> Self {
        self.max_width = Some(max_width);
        self
    }

    pub fn min_width(mut self, min_width: i32) -> Self {
        self.min_width = Some(min_width);
        self
    }

    pub fn reorderable(mut self, reorderable: bool) -> Self {
        self.reorderable = Some(reorderable);
        self
    }

    pub fn resizable(mut self, resizable: bool) -> Self {
        self.resizable = Some(resizable);
        self
    }

    pub fn sizing(mut self, sizing: TreeViewColumnSizing) -> Self {
        self.sizing = Some(sizing);
        self
    }

    pub fn sort_column_id(mut self, sort_column_id: i32) -> Self {
        self.sort_column_id = Some(sort_column_id);
        self
    }

    pub fn sort_indicator(mut self, sort_indicator: bool) -> Self {
        self.sort_indicator = Some(sort_indicator);
        self
    }

    pub fn sort_order(mut self, sort_order: SortType) -> Self {
        self.sort_order = Some(sort_order);
        self
    }

    pub fn spacing(mut self, spacing: i32) -> Self {
        self.spacing = Some(spacing);
        self
    }

    pub fn title(mut self, title: &str) -> Self {
        self.title = Some(title.to_string());
        self
    }

    pub fn visible(mut self, visible: bool) -> Self {
        self.visible = Some(visible);
        self
    }

    pub fn widget(mut self, widget: &Widget) -> Self {
        self.widget = Some(widget.clone());
        self
    }
}

pub const NONE_TREE_VIEW_COLUMN: Option<&TreeViewColumn> = None;

pub trait TreeViewColumnExt: 'static {
    fn cell_get_position<P: IsA<CellRenderer>>(&self, cell_renderer: &P) -> Option<(i32, i32)>;

    fn cell_get_size(&self, cell_area: Option<&gdk::Rectangle>) -> (i32, i32, i32, i32);

    fn cell_is_visible(&self) -> bool;

    fn cell_set_cell_data<P: IsA<TreeModel>>(
        &self,
        tree_model: &P,
        iter: &TreeIter,
        is_expander: bool,
        is_expanded: bool,
    );

    fn clicked(&self);

    fn focus_cell<P: IsA<CellRenderer>>(&self, cell: &P);

    fn get_alignment(&self) -> f32;

    fn get_button(&self) -> Option<Widget>;

    fn get_clickable(&self) -> bool;

    fn get_expand(&self) -> bool;

    fn get_fixed_width(&self) -> i32;

    fn get_max_width(&self) -> i32;

    fn get_min_width(&self) -> i32;

    fn get_reorderable(&self) -> bool;

    fn get_resizable(&self) -> bool;

    fn get_sizing(&self) -> TreeViewColumnSizing;

    fn get_sort_column_id(&self) -> i32;

    fn get_sort_indicator(&self) -> bool;

    fn get_sort_order(&self) -> SortType;

    fn get_spacing(&self) -> i32;

    fn get_title(&self) -> Option<GString>;

    fn get_tree_view(&self) -> Option<Widget>;

    fn get_visible(&self) -> bool;

    fn get_widget(&self) -> Option<Widget>;

    fn get_width(&self) -> i32;

    fn get_x_offset(&self) -> i32;

    fn queue_resize(&self);

    fn set_alignment(&self, xalign: f32);

    fn set_cell_data_func<P: IsA<CellRenderer>>(
        &self,
        cell_renderer: &P,
        func: Option<Box<dyn Fn(&TreeViewColumn, &CellRenderer, &TreeModel, &TreeIter) + 'static>>,
    );

    fn set_clickable(&self, clickable: bool);

    fn set_expand(&self, expand: bool);

    fn set_fixed_width(&self, fixed_width: i32);

    fn set_max_width(&self, max_width: i32);

    fn set_min_width(&self, min_width: i32);

    fn set_reorderable(&self, reorderable: bool);

    fn set_resizable(&self, resizable: bool);

    fn set_sizing(&self, type_: TreeViewColumnSizing);

    fn set_sort_column_id(&self, sort_column_id: i32);

    fn set_sort_indicator(&self, setting: bool);

    fn set_sort_order(&self, order: SortType);

    fn set_spacing(&self, spacing: i32);

    fn set_title(&self, title: &str);

    fn set_visible(&self, visible: bool);

    fn set_widget<P: IsA<Widget>>(&self, widget: Option<&P>);

    fn get_property_cell_area(&self) -> Option<CellArea>;

    fn connect_clicked<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_alignment_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_clickable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_expand_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_fixed_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_max_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_min_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_reorderable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_resizable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_sizing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_sort_column_id_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_sort_indicator_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_sort_order_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_spacing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_widget_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_x_offset_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<TreeViewColumn>> TreeViewColumnExt for O {
    fn cell_get_position<P: IsA<CellRenderer>>(&self, cell_renderer: &P) -> Option<(i32, i32)> {
        unsafe {
            let mut x_offset = mem::uninitialized();
            let mut width = mem::uninitialized();
            let ret = from_glib(gtk_sys::gtk_tree_view_column_cell_get_position(
                self.as_ref().to_glib_none().0,
                cell_renderer.as_ref().to_glib_none().0,
                &mut x_offset,
                &mut width,
            ));
            if ret {
                Some((x_offset, width))
            } else {
                None
            }
        }
    }

    fn cell_get_size(&self, cell_area: Option<&gdk::Rectangle>) -> (i32, i32, i32, i32) {
        unsafe {
            let mut x_offset = mem::uninitialized();
            let mut y_offset = mem::uninitialized();
            let mut width = mem::uninitialized();
            let mut height = mem::uninitialized();
            gtk_sys::gtk_tree_view_column_cell_get_size(
                self.as_ref().to_glib_none().0,
                cell_area.to_glib_none().0,
                &mut x_offset,
                &mut y_offset,
                &mut width,
                &mut height,
            );
            (x_offset, y_offset, width, height)
        }
    }

    fn cell_is_visible(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_tree_view_column_cell_is_visible(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn cell_set_cell_data<P: IsA<TreeModel>>(
        &self,
        tree_model: &P,
        iter: &TreeIter,
        is_expander: bool,
        is_expanded: bool,
    ) {
        unsafe {
            gtk_sys::gtk_tree_view_column_cell_set_cell_data(
                self.as_ref().to_glib_none().0,
                tree_model.as_ref().to_glib_none().0,
                mut_override(iter.to_glib_none().0),
                is_expander.to_glib(),
                is_expanded.to_glib(),
            );
        }
    }

    fn clicked(&self) {
        unsafe {
            gtk_sys::gtk_tree_view_column_clicked(self.as_ref().to_glib_none().0);
        }
    }

    fn focus_cell<P: IsA<CellRenderer>>(&self, cell: &P) {
        unsafe {
            gtk_sys::gtk_tree_view_column_focus_cell(
                self.as_ref().to_glib_none().0,
                cell.as_ref().to_glib_none().0,
            );
        }
    }

    fn get_alignment(&self) -> f32 {
        unsafe { gtk_sys::gtk_tree_view_column_get_alignment(self.as_ref().to_glib_none().0) }
    }

    fn get_button(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(gtk_sys::gtk_tree_view_column_get_button(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_clickable(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_tree_view_column_get_clickable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_expand(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_tree_view_column_get_expand(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_fixed_width(&self) -> i32 {
        unsafe { gtk_sys::gtk_tree_view_column_get_fixed_width(self.as_ref().to_glib_none().0) }
    }

    fn get_max_width(&self) -> i32 {
        unsafe { gtk_sys::gtk_tree_view_column_get_max_width(self.as_ref().to_glib_none().0) }
    }

    fn get_min_width(&self) -> i32 {
        unsafe { gtk_sys::gtk_tree_view_column_get_min_width(self.as_ref().to_glib_none().0) }
    }

    fn get_reorderable(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_tree_view_column_get_reorderable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_resizable(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_tree_view_column_get_resizable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_sizing(&self) -> TreeViewColumnSizing {
        unsafe {
            from_glib(gtk_sys::gtk_tree_view_column_get_sizing(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_sort_column_id(&self) -> i32 {
        unsafe { gtk_sys::gtk_tree_view_column_get_sort_column_id(self.as_ref().to_glib_none().0) }
    }

    fn get_sort_indicator(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_tree_view_column_get_sort_indicator(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_sort_order(&self) -> SortType {
        unsafe {
            from_glib(gtk_sys::gtk_tree_view_column_get_sort_order(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_spacing(&self) -> i32 {
        unsafe { gtk_sys::gtk_tree_view_column_get_spacing(self.as_ref().to_glib_none().0) }
    }

    fn get_title(&self) -> Option<GString> {
        unsafe {
            from_glib_none(gtk_sys::gtk_tree_view_column_get_title(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_tree_view(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(gtk_sys::gtk_tree_view_column_get_tree_view(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_visible(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_tree_view_column_get_visible(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_widget(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(gtk_sys::gtk_tree_view_column_get_widget(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_width(&self) -> i32 {
        unsafe { gtk_sys::gtk_tree_view_column_get_width(self.as_ref().to_glib_none().0) }
    }

    fn get_x_offset(&self) -> i32 {
        unsafe { gtk_sys::gtk_tree_view_column_get_x_offset(self.as_ref().to_glib_none().0) }
    }

    fn queue_resize(&self) {
        unsafe {
            gtk_sys::gtk_tree_view_column_queue_resize(self.as_ref().to_glib_none().0);
        }
    }

    fn set_alignment(&self, xalign: f32) {
        unsafe {
            gtk_sys::gtk_tree_view_column_set_alignment(self.as_ref().to_glib_none().0, xalign);
        }
    }

    fn set_cell_data_func<P: IsA<CellRenderer>>(
        &self,
        cell_renderer: &P,
        func: Option<Box<dyn Fn(&TreeViewColumn, &CellRenderer, &TreeModel, &TreeIter) + 'static>>,
    ) {
        let func_data: Box_<
            Option<Box<dyn Fn(&TreeViewColumn, &CellRenderer, &TreeModel, &TreeIter) + 'static>>,
        > = Box::new(func);
        unsafe extern "C" fn func_func<P: IsA<CellRenderer>>(
            tree_column: *mut gtk_sys::GtkTreeViewColumn,
            cell: *mut gtk_sys::GtkCellRenderer,
            tree_model: *mut gtk_sys::GtkTreeModel,
            iter: *mut gtk_sys::GtkTreeIter,
            data: glib_sys::gpointer,
        ) {
            let tree_column = from_glib_borrow(tree_column);
            let cell = from_glib_borrow(cell);
            let tree_model = from_glib_borrow(tree_model);
            let iter = from_glib_borrow(iter);
            let callback: &Option<
                Box<dyn Fn(&TreeViewColumn, &CellRenderer, &TreeModel, &TreeIter) + 'static>,
            > = &*(data as *mut _);
            if let Some(ref callback) = *callback {
                callback(&tree_column, &cell, &tree_model, &iter)
            } else {
                panic!("cannot get closure...")
            };
        }
        let func = if func_data.is_some() {
            Some(func_func::<P> as _)
        } else {
            None
        };
        unsafe extern "C" fn destroy_func<P: IsA<CellRenderer>>(data: glib_sys::gpointer) {
            let _callback: Box_<
                Option<
                    Box<dyn Fn(&TreeViewColumn, &CellRenderer, &TreeModel, &TreeIter) + 'static>,
                >,
            > = Box_::from_raw(data as *mut _);
        }
        let destroy_call4 = Some(destroy_func::<P> as _);
        let super_callback0: Box_<
            Option<Box<dyn Fn(&TreeViewColumn, &CellRenderer, &TreeModel, &TreeIter) + 'static>>,
        > = func_data;
        unsafe {
            gtk_sys::gtk_tree_view_column_set_cell_data_func(
                self.as_ref().to_glib_none().0,
                cell_renderer.as_ref().to_glib_none().0,
                func,
                Box::into_raw(super_callback0) as *mut _,
                destroy_call4,
            );
        }
    }

    fn set_clickable(&self, clickable: bool) {
        unsafe {
            gtk_sys::gtk_tree_view_column_set_clickable(
                self.as_ref().to_glib_none().0,
                clickable.to_glib(),
            );
        }
    }

    fn set_expand(&self, expand: bool) {
        unsafe {
            gtk_sys::gtk_tree_view_column_set_expand(
                self.as_ref().to_glib_none().0,
                expand.to_glib(),
            );
        }
    }

    fn set_fixed_width(&self, fixed_width: i32) {
        unsafe {
            gtk_sys::gtk_tree_view_column_set_fixed_width(
                self.as_ref().to_glib_none().0,
                fixed_width,
            );
        }
    }

    fn set_max_width(&self, max_width: i32) {
        unsafe {
            gtk_sys::gtk_tree_view_column_set_max_width(self.as_ref().to_glib_none().0, max_width);
        }
    }

    fn set_min_width(&self, min_width: i32) {
        unsafe {
            gtk_sys::gtk_tree_view_column_set_min_width(self.as_ref().to_glib_none().0, min_width);
        }
    }

    fn set_reorderable(&self, reorderable: bool) {
        unsafe {
            gtk_sys::gtk_tree_view_column_set_reorderable(
                self.as_ref().to_glib_none().0,
                reorderable.to_glib(),
            );
        }
    }

    fn set_resizable(&self, resizable: bool) {
        unsafe {
            gtk_sys::gtk_tree_view_column_set_resizable(
                self.as_ref().to_glib_none().0,
                resizable.to_glib(),
            );
        }
    }

    fn set_sizing(&self, type_: TreeViewColumnSizing) {
        unsafe {
            gtk_sys::gtk_tree_view_column_set_sizing(
                self.as_ref().to_glib_none().0,
                type_.to_glib(),
            );
        }
    }

    fn set_sort_column_id(&self, sort_column_id: i32) {
        unsafe {
            gtk_sys::gtk_tree_view_column_set_sort_column_id(
                self.as_ref().to_glib_none().0,
                sort_column_id,
            );
        }
    }

    fn set_sort_indicator(&self, setting: bool) {
        unsafe {
            gtk_sys::gtk_tree_view_column_set_sort_indicator(
                self.as_ref().to_glib_none().0,
                setting.to_glib(),
            );
        }
    }

    fn set_sort_order(&self, order: SortType) {
        unsafe {
            gtk_sys::gtk_tree_view_column_set_sort_order(
                self.as_ref().to_glib_none().0,
                order.to_glib(),
            );
        }
    }

    fn set_spacing(&self, spacing: i32) {
        unsafe {
            gtk_sys::gtk_tree_view_column_set_spacing(self.as_ref().to_glib_none().0, spacing);
        }
    }

    fn set_title(&self, title: &str) {
        unsafe {
            gtk_sys::gtk_tree_view_column_set_title(
                self.as_ref().to_glib_none().0,
                title.to_glib_none().0,
            );
        }
    }

    fn set_visible(&self, visible: bool) {
        unsafe {
            gtk_sys::gtk_tree_view_column_set_visible(
                self.as_ref().to_glib_none().0,
                visible.to_glib(),
            );
        }
    }

    fn set_widget<P: IsA<Widget>>(&self, widget: Option<&P>) {
        unsafe {
            gtk_sys::gtk_tree_view_column_set_widget(
                self.as_ref().to_glib_none().0,
                widget.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn get_property_cell_area(&self) -> Option<CellArea> {
        unsafe {
            let mut value = Value::from_type(<CellArea as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"cell-area\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value.get()
        }
    }

    fn connect_clicked<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn clicked_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTreeViewColumn,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TreeViewColumn>,
        {
            let f: &F = &*(f as *const F);
            f(&TreeViewColumn::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"clicked\0".as_ptr() as *const _,
                Some(transmute(clicked_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_alignment_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_alignment_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTreeViewColumn,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TreeViewColumn>,
        {
            let f: &F = &*(f as *const F);
            f(&TreeViewColumn::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::alignment\0".as_ptr() as *const _,
                Some(transmute(notify_alignment_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_clickable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_clickable_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTreeViewColumn,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TreeViewColumn>,
        {
            let f: &F = &*(f as *const F);
            f(&TreeViewColumn::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::clickable\0".as_ptr() as *const _,
                Some(transmute(notify_clickable_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_expand_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_expand_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTreeViewColumn,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TreeViewColumn>,
        {
            let f: &F = &*(f as *const F);
            f(&TreeViewColumn::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::expand\0".as_ptr() as *const _,
                Some(transmute(notify_expand_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_fixed_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_fixed_width_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTreeViewColumn,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TreeViewColumn>,
        {
            let f: &F = &*(f as *const F);
            f(&TreeViewColumn::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::fixed-width\0".as_ptr() as *const _,
                Some(transmute(notify_fixed_width_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_max_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_max_width_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTreeViewColumn,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TreeViewColumn>,
        {
            let f: &F = &*(f as *const F);
            f(&TreeViewColumn::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::max-width\0".as_ptr() as *const _,
                Some(transmute(notify_max_width_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_min_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_min_width_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTreeViewColumn,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TreeViewColumn>,
        {
            let f: &F = &*(f as *const F);
            f(&TreeViewColumn::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::min-width\0".as_ptr() as *const _,
                Some(transmute(notify_min_width_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_reorderable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_reorderable_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTreeViewColumn,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TreeViewColumn>,
        {
            let f: &F = &*(f as *const F);
            f(&TreeViewColumn::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::reorderable\0".as_ptr() as *const _,
                Some(transmute(notify_reorderable_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_resizable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_resizable_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTreeViewColumn,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TreeViewColumn>,
        {
            let f: &F = &*(f as *const F);
            f(&TreeViewColumn::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::resizable\0".as_ptr() as *const _,
                Some(transmute(notify_resizable_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_sizing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_sizing_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTreeViewColumn,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TreeViewColumn>,
        {
            let f: &F = &*(f as *const F);
            f(&TreeViewColumn::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::sizing\0".as_ptr() as *const _,
                Some(transmute(notify_sizing_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_sort_column_id_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_sort_column_id_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTreeViewColumn,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TreeViewColumn>,
        {
            let f: &F = &*(f as *const F);
            f(&TreeViewColumn::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::sort-column-id\0".as_ptr() as *const _,
                Some(transmute(
                    notify_sort_column_id_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_sort_indicator_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_sort_indicator_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTreeViewColumn,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TreeViewColumn>,
        {
            let f: &F = &*(f as *const F);
            f(&TreeViewColumn::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::sort-indicator\0".as_ptr() as *const _,
                Some(transmute(
                    notify_sort_indicator_trampoline::<Self, F> as usize,
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_sort_order_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_sort_order_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTreeViewColumn,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TreeViewColumn>,
        {
            let f: &F = &*(f as *const F);
            f(&TreeViewColumn::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::sort-order\0".as_ptr() as *const _,
                Some(transmute(notify_sort_order_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_spacing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_spacing_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTreeViewColumn,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TreeViewColumn>,
        {
            let f: &F = &*(f as *const F);
            f(&TreeViewColumn::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::spacing\0".as_ptr() as *const _,
                Some(transmute(notify_spacing_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_title_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTreeViewColumn,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TreeViewColumn>,
        {
            let f: &F = &*(f as *const F);
            f(&TreeViewColumn::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::title\0".as_ptr() as *const _,
                Some(transmute(notify_title_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_visible_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTreeViewColumn,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TreeViewColumn>,
        {
            let f: &F = &*(f as *const F);
            f(&TreeViewColumn::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::visible\0".as_ptr() as *const _,
                Some(transmute(notify_visible_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_widget_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_widget_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTreeViewColumn,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TreeViewColumn>,
        {
            let f: &F = &*(f as *const F);
            f(&TreeViewColumn::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::widget\0".as_ptr() as *const _,
                Some(transmute(notify_widget_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_width_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTreeViewColumn,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TreeViewColumn>,
        {
            let f: &F = &*(f as *const F);
            f(&TreeViewColumn::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::width\0".as_ptr() as *const _,
                Some(transmute(notify_width_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_x_offset_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_x_offset_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkTreeViewColumn,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<TreeViewColumn>,
        {
            let f: &F = &*(f as *const F);
            f(&TreeViewColumn::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::x-offset\0".as_ptr() as *const _,
                Some(transmute(notify_x_offset_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for TreeViewColumn {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "TreeViewColumn")
    }
}
