# frozen_string_literal: true

require "bundler/setup"
require "android_key_attestation"

require "pry-byebug"

RSpec.configure do |config|
  # Enable flags like --only-failures and --next-failure
  config.example_status_persistence_file_path = ".rspec_status"

  # Disable RSpec exposing methods globally on `Module` and `main`
  config.disable_monkey_patching!

  config.expect_with :rspec do |c|
    c.syntax = :expect
  end

  config.order = :random
end

def test_certificate
  @test_certificate ||= OpenSSL::X509::Certificate.new(File.read(File.join(__dir__, "test_certificate.pem")))
end
