% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\name{context_accessors}
\alias{context_accessors}
\alias{.G}
\alias{.N}
\alias{.E}
\title{Access graph, nodes, and edges directly inside verbs}
\usage{
.G()

.N()

.E()
}
\value{
Either a \code{tbl_graph} (\code{.G()}) or a \code{tibble} (\code{.N()})
}
\description{
These three functions makes it possible to directly access either the node
data, the edge data or the graph itself while computing inside verbs. It is
e.g. possible to add an attribute from the node data to the edges based on
the terminating nodes of the edge, or extract some statistics from the graph
itself to use in computations.
}
\section{Functions}{
\itemize{
\item \code{.G()}: Get the tbl_graph you're currently working on

\item \code{.N()}: Get the nodes data from the graph you're currently working on

\item \code{.E()}: Get the edges data from the graph you're currently working on

}}
\examples{

# Get data from the nodes while computing for the edges
create_notable('bull') \%>\%
  activate(nodes) \%>\%
  mutate(centrality = centrality_power()) \%>\%
  activate(edges) \%>\%
  mutate(mean_centrality = (.N()$centrality[from] + .N()$centrality[to])/2)
}
