% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/dimreduc.R, R/seurat.R
\name{Loadings}
\alias{Loadings}
\alias{Loadings<-}
\alias{Loadings.DimReduc}
\alias{Loadings<-.DimReduc}
\alias{Loadings.Seurat}
\title{Get and set feature loadings}
\usage{
Loadings(object, ...)

Loadings(object, ...) <- value

\method{Loadings}{DimReduc}(object, projected = FALSE, ...)

\method{Loadings}{DimReduc}(object, projected = TRUE, ...) <- value

\method{Loadings}{Seurat}(object, reduction = "pca", projected = FALSE, ...)
}
\arguments{
\item{object}{An object}

\item{...}{Arguments passed to other methods}

\item{value}{Feature loadings to add}

\item{projected}{Pull the projected feature loadings?}

\item{reduction}{Name of reduction to pull feature loadings for}
}
\value{
\code{Loadings}: the feature loadings for \code{object}

\code{Loadings<-}: \code{object} with the updated loadings
}
\description{
Get and set feature loadings
}
\examples{
# Get the feature loadings for a given DimReduc
Loadings(object = pbmc_small[["pca"]])[1:5,1:5]

# Set the feature loadings for a given DimReduc
new.loadings <- Loadings(object = pbmc_small[["pca"]])
new.loadings <- new.loadings + 0.01
Loadings(object = pbmc_small[["pca"]]) <- new.loadings

# Get the feature loadings for a specified DimReduc in a Seurat object
Loadings(object = pbmc_small, reduction = "pca")[1:5,1:5]

}
\concept{data-access}
