% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RNG.R
\docType{methods}
\name{.setRNG}
\alias{.setRNG}
\alias{.setRNG,character-method}
\alias{.setRNG,numeric-method}
\title{Setting RNG Seeds}
\usage{
.setRNG(object, ...)

\S4method{.setRNG}{character}(object, ...)

\S4method{.setRNG}{numeric}(object, ...)
}
\arguments{
\item{object}{an R object from which RNG settings can be extracted, e.g. an
integer vector containing a suitable value for \code{.Random.seed} or embedded
RNG data, e.g., in S3/S4 slot \code{rng} or \code{rng$noise}.}

\item{...}{extra arguments to allow extension and passed to a suitable S4 method
\code{.getRNG} or \code{.setRNG}.}
}
\description{
\code{.setRNG} is an S4 generic that sets the current RNG settings, from a
variety of specifications.
Its methods define the workhorse functions that are called by \code{setRNG}.
}
\section{Methods (by class)}{

"character": Sets the RNG to kind \code{object}, assuming is a valid RNG kind:
it is equivalent to \code{RNGkind(object, ...}.
All arguments in \code{...} are passed to \code{\link{RNGkind}}.


"numeric": Sets the RNG settings using \code{object} directly the new value for
\code{.Random.seed} or to initialise it with \code{\link{set.seed}}.
}

\examples{
# set RNG kind
old <- setRNG('Marsaglia')
# restore
setRNG(old)

# directly set .Random.seed
rng <- getRNG()
r <- runif(10)
setRNG(rng)
rng.equal(rng)

# initialise from a single number (<=> set.seed)
setRNG(123)
rng <- getRNG()
runif(10)
set.seed(123)
rng.equal(rng)

}
