% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simSeq.R
\name{simSeq}
\alias{simSeq}
\alias{simSeq.phylo}
\alias{simSeq.pml}
\title{Simulate sequences.}
\usage{
simSeq(x, ...)

\method{simSeq}{phylo}(x, l = 1000, Q = NULL, bf = NULL,
  rootseq = NULL, type = "DNA", model = NULL, levels = NULL,
  rate = 1, ancestral = FALSE, code = 1, ...)

\method{simSeq}{pml}(x, ancestral = FALSE, ...)
}
\arguments{
\item{x}{a phylogenetic tree \code{tree}, i.e. an object of class
\code{phylo} or and object of class \code{pml}.}

\item{\dots}{Further arguments passed to or from other methods.}

\item{l}{The length of the sequence to simulate.}

\item{Q}{The rate matrix.}

\item{bf}{Base frequencies.}

\item{rootseq}{A vector of length \code{l} containing the root sequence.
If not provided, the root sequence is randomly generated.}

\item{type}{Type of sequences ("DNA", "AA", "CODON" or "USER").}

\item{model}{Amino acid model of evolution to employ, for example "WAG",
"JTT", "Dayhoff" or "LG". For a full list of supported models, type
\code{phangorn:::.aamodels}. Ignored if type is not equal to "AA".}

\item{levels}{A character vector of the different character tokens.
Ignored unless type = "USER".}

\item{rate}{A numerical value greater than zero giving the mutation rate
or scaler for edge lengths.}

\item{ancestral}{Logical specifying whether to return ancestral sequences.}

\item{code}{The ncbi genetic code number for translation (see details). By
default the standard genetic code is used.}
}
\value{
\code{simSeq} returns an object of class phyDat.
}
\description{
Simulate sequences from a given evolutionary tree.
}
\details{
\code{simSeq} is a generic function to simulate sequence alignments
along a phylogeny. It is quite flexible and can generate DNA, RNA,
amino acids, codon, morphological or binary sequences.
simSeq can take as input a phylogenetic tree of class \code{phylo},
or a \code{pml} object; it will return an object of class \code{phyDat}.
There is also a more low level
version, which lacks rate variation, but one can combine different
alignments with their own rates (see example). The rate parameter acts like
a scaler for the edge lengths.

For codon models \code{type="CODON"}, two additional arguments \code{dnds}
for the dN/dS ratio and \code{tstv} for the transition transversion ratio
can be supplied.

\strong{Defaults:}

If \code{x} is a tree of class \code{phylo}, then sequences will be generated
with the default Jukes-Cantor DNA model (\code{"JC"}).

If \code{bf} is not specified, then all states will be treated as equally
probable.

If \code{Q} is not specified, then a uniform rate matrix will be employed.
}
\examples{

\dontrun{
data(Laurasiatherian)
tree <- nj(dist.ml(Laurasiatherian))
fit <- pml(tree, Laurasiatherian, k=4)
fit <- optim.pml(fit, optNni=TRUE, model="GTR", optGamma=TRUE)
data <- simSeq(fit)
}


tree <- rtree(5)
plot(tree)
nodelabels()

# Example for simple DNA alignment
data <- simSeq(tree, l = 10, type="DNA", bf=c(.1,.2,.3,.4), Q=1:6,
               ancestral=TRUE)
as.character(data)


# Example to simulate discrete Gamma rate variation
rates <- discrete.gamma(1,4)
data1 <- simSeq(tree, l = 100, type="AA", model="WAG", rate=rates[1])
data2 <- simSeq(tree, l = 100, type="AA", model="WAG", rate=rates[2])
data3 <- simSeq(tree, l = 100, type="AA", model="WAG", rate=rates[3])
data4 <- simSeq(tree, l = 100, type="AA", model="WAG", rate=rates[4])
data <- c(data1,data2, data3, data4)

write.phyDat(data, file="temp.dat", format="sequential", nbcol = -1,
  colsep = "")
unlink("temp.dat")

}
\seealso{
\code{\link{phyDat}}, \code{\link{pml}}, \code{\link{SOWH.test}}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
\keyword{cluster}
