% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Regression.R
\name{MAPE}
\alias{MAPE}
\title{Mean Absolute Percentage Error Loss}
\usage{
MAPE(y_pred, y_true)
}
\arguments{
\item{y_pred}{Estimated target values vector}

\item{y_true}{Ground truth (correct) target values vector}
}
\value{
Mean Absolute Percentage Error Loss
}
\description{
Compute the mean absolute percentage error regression loss.
}
\examples{
data(cars)
reg <- lm(log(dist) ~ log(speed), data = cars)
MAPE(y_pred = exp(reg$fitted.values), y_true = cars$dist)
}

