% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_value.R
\name{format_value}
\alias{format_value}
\alias{format_value.data.frame}
\alias{format_value.numeric}
\alias{format_percent}
\title{Numeric Values Formatting}
\usage{
format_value(x, ...)

\method{format_value}{data.frame}(
  x,
  digits = 2,
  protect_integers = FALSE,
  missing = "",
  width = NULL,
  as_percent = FALSE,
  zap_small = FALSE,
  lead_zero = TRUE,
  style_positive = "none",
  style_negative = "hyphen",
  decimal_point = getOption("OutDec"),
  ...
)

\method{format_value}{numeric}(
  x,
  digits = 2,
  protect_integers = FALSE,
  missing = "",
  width = NULL,
  as_percent = FALSE,
  zap_small = FALSE,
  lead_zero = TRUE,
  style_positive = "none",
  style_negative = "hyphen",
  decimal_point = getOption("OutDec"),
  ...
)

format_percent(x, ...)
}
\arguments{
\item{x}{Numeric value.}

\item{...}{Arguments passed to or from other methods.}

\item{digits}{Number of digits for rounding or significant figures. May also
be \code{"signif"} to return significant figures or \code{"scientific"}
to return scientific notation. Control the number of digits by adding the
value as suffix, e.g. \code{digits = "scientific4"} to have scientific
notation with 4 decimal places, or \code{digits = "signif5"} for 5
significant figures (see also \code{\link[=signif]{signif()}}).}

\item{protect_integers}{Should integers be kept as integers (i.e., without
decimals)?}

\item{missing}{Value by which \code{NA} values are replaced. By default, an
empty string (i.e. \code{""}) is returned for \code{NA}.}

\item{width}{Minimum width of the returned string. If not \code{NULL} and
\code{width} is larger than the string's length, leading whitespaces are
added to the string.}

\item{as_percent}{Logical, if \code{TRUE}, value is formatted as percentage
value.}

\item{zap_small}{Logical, if \code{TRUE}, small values are rounded after
\code{digits} decimal places. If \code{FALSE}, values with more decimal
places than \code{digits} are printed in scientific notation.}

\item{lead_zero}{Logical, if \code{TRUE} (default), includes leading zeros, else
leading zeros are dropped.}

\item{style_positive}{A string that determines the style of positive numbers.
May be \code{"none"} (default), \code{"plus"} to add a plus-sign or \code{"space"} to
precede the string by a Unicode "figure space", i.e., a space equally as
wide as a number or \code{+}.}

\item{style_negative}{A string that determines the style of negative numbers.
May be \code{"hyphen"} (default), \code{"minus"} for a proper Unicode minus symbol or
\code{"parens"} to wrap the number in parentheses.}

\item{decimal_point}{Character string containing a single character that
is used as decimal point in output conversions.}
}
\value{
A formatted string.
}
\description{
\code{format_value()} converts numeric values into formatted string values, where
formatting can be something like rounding digits, scientific notation etc.
\code{format_percent()} is a short-cut for \code{format_value(as_percent = TRUE)}.
}
\examples{
format_value(1.20)
format_value(1.2)
format_value(1.2012313)
format_value(c(0.0045, 234, -23))
format_value(c(0.0045, 0.12, 0.34))
format_value(c(0.0045, 0.12, 0.34), as_percent = TRUE)
format_value(c(0.0045, 0.12, 0.34), digits = "scientific")
format_value(c(0.0045, 0.12, 0.34), digits = "scientific2")
format_value(c(0.045, 0.12, 0.34), lead_zero = FALSE)
format_value(c(0.0045, 0.12, 0.34), decimal_point = ",")

# default
format_value(c(0.0045, 0.123, 0.345))
# significant figures
format_value(c(0.0045, 0.123, 0.345), digits = "signif")

format_value(as.factor(c("A", "B", "A")))
format_value(iris$Species)

format_value(3)
format_value(3, protect_integers = TRUE)

format_value(head(iris))
}
