% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cmty_louvain.R
\name{get_cmty_louvain}
\alias{get_cmty_louvain}
\title{Get community membership by Louvain optimization}
\usage{
get_cmty_louvain(graph)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}
}
\value{
A data frame with group membership assignments for each of the nodes.
}
\description{
Through the use of multi-level optimization of a modularity score, obtain the
group membership values for each of the nodes in the graph.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph(
    directed = FALSE) \%>\%
  add_gnm_graph(
    n = 10,
    m = 15,
    set_seed = 23)

# Get the group membership values
# for all nodes in the graph
# through the multi-level
# optimization of modularity
# algorithm
graph \%>\%
  get_cmty_louvain()

# Add the group membership
# values to the graph as a
# node attribute
graph <-
  graph \%>\%
  join_node_attrs(
    df = get_cmty_louvain(.))

# Display the graph's
# node data frame
graph \%>\% get_node_df()

}
