% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_calculated_row.R
\name{add_calculated_row}
\alias{add_calculated_row}
\title{Add Calculated Row}
\usage{
add_calculated_row(
  x,
  expr,
  stat_name,
  by = c(all_ard_groups(), all_ard_variables(), any_of("context")),
  stat_label = stat_name,
  fmt_fn = NULL
)
}
\arguments{
\item{x}{(\code{card})\cr
data frame of class \code{'card'}}

\item{expr}{(\code{expression})\cr
an expression}

\item{stat_name}{(\code{string})\cr
string naming the new statistic}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Grouping variables to calculate statistics within}

\item{stat_label}{(\code{string})\cr
string of the statistic label. Default is the \code{stat_name}.}

\item{fmt_fn}{(\code{integer}, \code{function}, \code{string})\cr
a function of an integer or string that can be converted to a function with
\code{alias_as_fmt_fn()}.}
}
\value{
an ARD data frame of class 'card'
}
\description{
Use this function to add a new statistic row that is a function of the
other statistics in an ARD.
}
\examples{
ard_continuous(mtcars, variables = mpg) |>
  add_calculated_row(expr = max - min, stat_name = "range")

ard_continuous(mtcars, variables = mpg) |>
  add_calculated_row(
    expr =
      dplyr::case_when(
        mean > median ~ "Right Skew",
        mean < median ~ "Left Skew",
        .default = "Symmetric"
      ),
    stat_name = "skew"
  )
}
