% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowVars.R
\name{rowVars}
\alias{rowVars}
\alias{rowVars,matrix_OR_array_OR_table_OR_numeric-method}
\alias{rowVars,ANY-method}
\alias{colVars}
\alias{colVars,matrix_OR_array_OR_table_OR_numeric-method}
\alias{colVars,ANY-method}
\title{Calculates the variance for each row (column) of a matrix-like object}
\usage{
rowVars(x, rows = NULL, cols = NULL, na.rm = FALSE, center = NULL, ...,
  useNames = TRUE)

\S4method{rowVars}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL,
  cols = NULL, na.rm = FALSE, center = NULL, dim. = dim(x), ...,
  useNames = TRUE)

\S4method{rowVars}{ANY}(x, rows = NULL, cols = NULL, na.rm = FALSE,
  center = NULL, ..., useNames = TRUE)

colVars(x, rows = NULL, cols = NULL, na.rm = FALSE, center = NULL, ...,
  useNames = TRUE)

\S4method{colVars}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL,
  cols = NULL, na.rm = FALSE, center = NULL, dim. = dim(x), ...,
  useNames = TRUE)

\S4method{colVars}{ANY}(x, rows = NULL, cols = NULL, na.rm = FALSE,
  center = NULL, ..., useNames = TRUE)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{na.rm}{If \code{\link[base]{TRUE}}, missing values
(\code{\link[base]{NA}} or \code{\link[base]{NaN}}) are
omitted from the calculations.}

\item{center}{(optional) the center, defaults to the row means.}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{TRUE}} (default), names attributes of result are set. Else if \code{\link{FALSE}}, no naming support is done.}

\item{dim.}{An \code{\link{integer}} \code{\link{vector}} of length two
specifying the dimension of \code{x}, essential when x is a
\code{\link{numeric}} vector. Note, that this is not a generic
argument and not all methods need provide it.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the variance for each row (column) of a matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowVars}} /
\code{matrixStats::\link[matrixStats]{colVars}}.
}
\examples{
mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
mat[2, 1] <- NA
mat[3, 3] <- Inf
mat[4, 1] <- 0

print(mat)

rowVars(mat)
colVars(mat)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowVars}()} and
\code{matrixStats::\link[matrixStats:rowVars]{colVars}()} which are used
when the input is a \code{matrix} or \code{numeric} vector.
\item For mean estimates, see \code{\link{rowMeans2}()} and
\code{\link[base:colSums]{rowMeans}()}.
\item For standard deviation estimates, see \code{\link{rowSds}()}.
\item \code{stats::\link[stats:cor]{var}()}.
}
}
\keyword{array}
\keyword{iteration}
\keyword{robust}
\keyword{univar}
