% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cacheDirectory.R
\name{cacheDirectory}
\alias{cacheDirectory}
\title{Cache directory}
\usage{
cacheDirectory(dir)
}
\arguments{
\item{dir}{String containing the path to a cache directory.}
}
\value{
If \code{dir} is missing, the current setting of the cache directory is returned.

If \code{dir} is provided, it is used to replace the current setting of the cache directory,
and the \emph{previous} setting is invisibly returned.
}
\description{
Specify the cache directory in the local filesystem for gypsum-related data.
}
\details{
If the \code{GYPSUM_CACHE_DIR} environment variable is set before the first call to \code{\link{cacheDirectory}}, it is used as the initial location of the cache directory.
Otherwise, the initial location is based on \code{\link{R_user_dir}}.
}
\examples{
cacheDirectory()
old <- cacheDirectory(tempfile())
cacheDirectory()
cacheDirectory(old) # setting it back.

}
\author{
Aaron Lun
}
