/*
 * The internal definitions
 *
 * Copyright (C) 2014-2018, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This software is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software.  If not, see <http://www.gnu.org/licenses/>.
 */

#if !defined( _LIBVSLVM_INTERNAL_DEFINITIONS_H )
#define _LIBVSLVM_INTERNAL_DEFINITIONS_H

#include <common.h>

/* Define HAVE_LOCAL_LIBVSLVM for local use of libvslvm
 */
#if !defined( HAVE_LOCAL_LIBVSLVM )
#include <libvslvm/definitions.h>

/* The definitions in <libvslvm/definitions.h> are copied here
 * for local use of libvslvm
 */
#else
#define LIBVSLVM_VERSION					20181227

/* The libvslvm version string
 */
#define LIBVSLVM_VERSION_STRING					"20181227"

/* The endian definitions
 */
#define LIBVSLVM_ENDIAN_BIG					_BYTE_STREAM_ENDIAN_BIG
#define LIBVSLVM_ENDIAN_LITTLE					_BYTE_STREAM_ENDIAN_LITTLE

/* The access flags definitions
 * bit 1        set to 1 for read access
 * bit 2        set to 1 for write access
 * bit 3-8      not used
 */
enum LIBVSLVM_ACCESS_FLAGS
{
	LIBVSLVM_ACCESS_FLAG_READ				= 0x01,
/* Reserved: not supported yet */
	LIBVSLVM_ACCESS_FLAG_WRITE				= 0x02
};

/* The file access macros
 */
#define LIBVSLVM_OPEN_READ					( LIBVSLVM_ACCESS_FLAG_READ )
/* Reserved: not supported yet */
#define LIBVSLVM_OPEN_WRITE					( LIBVSLVM_ACCESS_FLAG_WRITE )
/* Reserved: not supported yet */
#define LIBVSLVM_OPEN_READ_WRITE				( LIBVSLVM_ACCESS_FLAG_READ | LIBVSLVM_ACCESS_FLAG_WRITE )

#endif /* !defined( HAVE_LOCAL_LIBVSLVM ) */

/* The raw location descriptor flags
 */
enum LIBVSLVM_RAW_LOCATION_DESCRIPTOR_FLAGS
{
	LIBVSLVM_RAW_LOCATION_DESCRIPTOR_FLAG_IGNORE		= 0x00000001UL
};

#define LIBVSLVM_MAXIMUM_CACHE_ENTRIES_PHYSICAL_VOLUMES		4
#define LIBVSLVM_MAXIMUM_CACHE_ENTRIES_CHUNKS			16

#endif /* !defined( _LIBVSLVM_INTERNAL_DEFINITIONS_H ) */

