//------------------------------------------------------------------------------
//$Author: saulius $
//$Date: 2015-06-12 06:06:39 -0400 (Fri, 12 Jun 2015) $
//$Revision: 63 $
//$URL: svn://saulius-grazulis.lt/libraries/trunk/java/SOptions/topt.java $
//------------------------------------------------------------------------------

import java.io.*;

class MyFunctionOption extends Option {

    MyFunctionOption( String short_name, String long_name, OptionType opt_type )
    {
        super( short_name, long_name, opt_type );
    }

    int proc( String args[], int i ) {
        System.out.println( "Hi, I am a 'MyFunctionOption.proc()' method " +
                            "with i = " + i + " having 'args[i]' value '" +
                            args[i] + "'" );
        return i;
    }
}

class topt {

    static Option options[];

    public static void main( String [] args )
    {
        OptionValue svalue = new OptionValue();
        OptionValue ivalue = new OptionValue();
        OptionValue fvalue = new OptionValue();
        OptionValue dvalue = new OptionValue();

        topt.options = new Option[] {
            new Option( "-a", "--all",       OptionType.OT_BOOLEAN_FALSE  ),
            new Option( "-v", "--verbose",   OptionType.OT_BOOLEAN_TRUE   ),
            new Option( "-s", "--strval",    OptionType.OT_STRING, svalue ),
            new Option( "-i", "--intval",    OptionType.OT_INT,    ivalue ),
            new Option( "-f", "--floatval",  OptionType.OT_FLOAT,  fvalue ),
            new Option( "-d", "--doubleval", OptionType.OT_FLOAT,  dvalue ),
            new MyFunctionOption( "-p", "--proc", OptionType.OT_FUNCTION ),
        };

        String files[] = null;
        try {
            files = SOptions.get_options( args, topt.options );
        }
        catch (SOptionsException e) {
            System.err.println( "topt: " + e.getMessage() );
        }

        if( svalue.present ) {
            System.out.println( "option '-s' value = " +  svalue.s );
        }

        if( ivalue.present ) {
            System.out.println( "option '-i' value = " +  ivalue.i );
        }

        if( fvalue.present ) {
            System.out.println( "option '-f' value = " +  fvalue.f );
        }

        if( fvalue.present ) {
            System.out.println( "option '-d' value = " +  dvalue.f );
        }

        if( files != null ) {
            for( int i = 0; i < files.length; i++ ) {
                System.out.println( "file: '" + files[i] + "'" );
            }
        }
    }
}
