/*
 *  common.h - common headers
 *
 *  Copyright (c) 1998 - 2004 Mike D. Schiffman <mike@infonexus.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#if (_WIN32) || (__CYGWIN__)

  /* MSVC warns about snprintf */
  #define _CRT_SECURE_NO_WARNINGS

  /* don't pull in Packet32's locol bpf definitions */
  // #define BPF_MAJOR_VERSION
  #include <Packet32.h>

/* don't pull in pcap/bpf.h */
  #define PCAP_DONT_INCLUDE_PCAP_BPF_H
  #include <pcap/pcap.h>

  #include <malloc.h>    /* alloca() */

#ifdef __MINGW32__
  #include <ntddndis.h>
#else
  #include <Ntddndis.h>
#endif

#else

#include <assert.h>
#include <sys/types.h>
#include <netinet/in.h>

/* TODO - should ../include/gnuc.h be included here? */

/* TODO - HAVE_OS_PROTO_H is never defined, but used in some files, delete it */

#endif

#include <config.h>
#include "../include/libnet.h"

/* IPPROTO_ and sockaddr_ definitions are here. They are often
 * implicitly pulled in, but some systems need them explicitly
 * included.
 */
#ifndef IPPROTO_MH
#define IPPROTO_MH		135	/* IPv6 mobility header		*/
#endif

/**
 * Local Variables:
 *  indent-tabs-mode: nil
 *  c-file-style: "stroustrup"
 * End:
 */
