/*
 * CLOUD API
 *
 *  IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// CreateSnapshotProperties struct for CreateSnapshotProperties
type CreateSnapshotProperties struct {
	// The name of the snapshot
	Name *string `json:"name,omitempty"`
	// The description of the snapshot
	Description *string `json:"description,omitempty"`
	// Flag representing if extra protection is enabled on snapshot e.g. Two Factor protection etc.
	SecAuthProtection *bool `json:"secAuthProtection,omitempty"`
	// OS type of this Snapshot
	LicenceType *string `json:"licenceType,omitempty"`
}

// NewCreateSnapshotProperties instantiates a new CreateSnapshotProperties object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCreateSnapshotProperties() *CreateSnapshotProperties {
	this := CreateSnapshotProperties{}

	return &this
}

// NewCreateSnapshotPropertiesWithDefaults instantiates a new CreateSnapshotProperties object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCreateSnapshotPropertiesWithDefaults() *CreateSnapshotProperties {
	this := CreateSnapshotProperties{}
	return &this
}

// GetName returns the Name field value
// If the value is explicit nil, nil is returned
func (o *CreateSnapshotProperties) GetName() *string {
	if o == nil {
		return nil
	}

	return o.Name

}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *CreateSnapshotProperties) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Name, true
}

// SetName sets field value
func (o *CreateSnapshotProperties) SetName(v string) {

	o.Name = &v

}

// HasName returns a boolean if a field has been set.
func (o *CreateSnapshotProperties) HasName() bool {
	if o != nil && o.Name != nil {
		return true
	}

	return false
}

// GetDescription returns the Description field value
// If the value is explicit nil, nil is returned
func (o *CreateSnapshotProperties) GetDescription() *string {
	if o == nil {
		return nil
	}

	return o.Description

}

// GetDescriptionOk returns a tuple with the Description field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *CreateSnapshotProperties) GetDescriptionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Description, true
}

// SetDescription sets field value
func (o *CreateSnapshotProperties) SetDescription(v string) {

	o.Description = &v

}

// HasDescription returns a boolean if a field has been set.
func (o *CreateSnapshotProperties) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// GetSecAuthProtection returns the SecAuthProtection field value
// If the value is explicit nil, nil is returned
func (o *CreateSnapshotProperties) GetSecAuthProtection() *bool {
	if o == nil {
		return nil
	}

	return o.SecAuthProtection

}

// GetSecAuthProtectionOk returns a tuple with the SecAuthProtection field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *CreateSnapshotProperties) GetSecAuthProtectionOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}

	return o.SecAuthProtection, true
}

// SetSecAuthProtection sets field value
func (o *CreateSnapshotProperties) SetSecAuthProtection(v bool) {

	o.SecAuthProtection = &v

}

// HasSecAuthProtection returns a boolean if a field has been set.
func (o *CreateSnapshotProperties) HasSecAuthProtection() bool {
	if o != nil && o.SecAuthProtection != nil {
		return true
	}

	return false
}

// GetLicenceType returns the LicenceType field value
// If the value is explicit nil, nil is returned
func (o *CreateSnapshotProperties) GetLicenceType() *string {
	if o == nil {
		return nil
	}

	return o.LicenceType

}

// GetLicenceTypeOk returns a tuple with the LicenceType field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *CreateSnapshotProperties) GetLicenceTypeOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.LicenceType, true
}

// SetLicenceType sets field value
func (o *CreateSnapshotProperties) SetLicenceType(v string) {

	o.LicenceType = &v

}

// HasLicenceType returns a boolean if a field has been set.
func (o *CreateSnapshotProperties) HasLicenceType() bool {
	if o != nil && o.LicenceType != nil {
		return true
	}

	return false
}

func (o CreateSnapshotProperties) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Name != nil {
		toSerialize["name"] = o.Name
	}

	if o.Description != nil {
		toSerialize["description"] = o.Description
	}

	if o.SecAuthProtection != nil {
		toSerialize["secAuthProtection"] = o.SecAuthProtection
	}

	if o.LicenceType != nil {
		toSerialize["licenceType"] = o.LicenceType
	}

	return json.Marshal(toSerialize)
}

type NullableCreateSnapshotProperties struct {
	value *CreateSnapshotProperties
	isSet bool
}

func (v NullableCreateSnapshotProperties) Get() *CreateSnapshotProperties {
	return v.value
}

func (v *NullableCreateSnapshotProperties) Set(val *CreateSnapshotProperties) {
	v.value = val
	v.isSet = true
}

func (v NullableCreateSnapshotProperties) IsSet() bool {
	return v.isSet
}

func (v *NullableCreateSnapshotProperties) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCreateSnapshotProperties(val *CreateSnapshotProperties) *NullableCreateSnapshotProperties {
	return &NullableCreateSnapshotProperties{value: val, isSet: true}
}

func (v NullableCreateSnapshotProperties) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCreateSnapshotProperties) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
