// Same copyright and license as the rest of the files in this project
// This file contains accelerator related functions and structures

// +build !gtk_3_6,!gtk_3_8,!gtk_3_10
// not use this: go build -tags gtk_3_8'. Otherwise, if no build tags are used, GTK 3.10

package gtk

// #include <stdlib.h>
// #include <gtk/gtk.h>
// #include "gtk_since_3_10.go.h"
import "C"
import (
	"unsafe"
)

// GetChildByName is a wrapper around gtk_stack_get_child_by_name().
func (v *Stack) GetChildByName(name string) (IWidget, error) {
	cstr := C.CString(name)
	defer C.free(unsafe.Pointer(cstr))
	c := C.gtk_stack_get_child_by_name(v.native(), (*C.gchar)(cstr))
	if c == nil {
		return nil, nilPtrErr
	}
	return castWidget(c)
}

// GetTransitionRunning is a wrapper around gtk_stack_get_transition_running().
func (v *Stack) GetTransitionRunning() bool {
	c := C.gtk_stack_get_transition_running(v.native())
	return gobool(c)
}
