// Code generated by smithy-go-codegen DO NOT EDIT.

package iotsitewise

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotsitewise/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a custom composite model from specified property and hierarchy
// definitions. There are two types of custom composite models, inline and
// component-model-based .
//
// Use component-model-based custom composite models to define standard, reusable
// components. A component-model-based custom composite model consists of a name, a
// description, and the ID of the component model it references. A
// component-model-based custom composite model has no properties of its own; its
// referenced component model provides its associated properties to any created
// assets. For more information, see [Custom composite models (Components)]in the IoT SiteWise User Guide.
//
// Use inline custom composite models to organize the properties of an asset
// model. The properties of inline custom composite models are local to the asset
// model where they are included and can't be used to create multiple assets.
//
// To create a component-model-based model, specify the composedAssetModelId of an
// existing asset model with assetModelType of COMPONENT_MODEL .
//
// To create an inline model, specify the assetModelCompositeModelProperties and
// don't include an composedAssetModelId .
//
// [Custom composite models (Components)]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/custom-composite-models.html
func (c *Client) CreateAssetModelCompositeModel(ctx context.Context, params *CreateAssetModelCompositeModelInput, optFns ...func(*Options)) (*CreateAssetModelCompositeModelOutput, error) {
	if params == nil {
		params = &CreateAssetModelCompositeModelInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateAssetModelCompositeModel", params, optFns, c.addOperationCreateAssetModelCompositeModelMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateAssetModelCompositeModelOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateAssetModelCompositeModelInput struct {

	// A unique, friendly name for the composite model.
	//
	// This member is required.
	AssetModelCompositeModelName *string

	// The composite model type. Valid values are AWS/ALARM , CUSTOM , or
	// AWS/L4E_ANOMALY .
	//
	// This member is required.
	AssetModelCompositeModelType *string

	// The ID of the asset model this composite model is a part of.
	//
	// This member is required.
	AssetModelId *string

	// A description for the composite model.
	AssetModelCompositeModelDescription *string

	// An external ID to assign to the composite model.
	//
	// If the composite model is a derived composite model, or one nested inside a
	// component model, you can only set the external ID using
	// UpdateAssetModelCompositeModel and specifying the derived ID of the model or
	// property from the created model it's a part of.
	AssetModelCompositeModelExternalId *string

	// The ID of the composite model. IoT SiteWise automatically generates a unique ID
	// for you, so this parameter is never required. However, if you prefer to supply
	// your own ID instead, you can specify it here in UUID format. If you specify your
	// own ID, it must be globally unique.
	AssetModelCompositeModelId *string

	// The property definitions of the composite model. For more information, see .
	//
	// You can specify up to 200 properties per composite model. For more information,
	// see [Quotas]in the IoT SiteWise User Guide.
	//
	// [Quotas]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html
	AssetModelCompositeModelProperties []types.AssetModelPropertyDefinition

	// A unique case-sensitive identifier that you can provide to ensure the
	// idempotency of the request. Don't reuse this client token if a new idempotent
	// request is required.
	ClientToken *string

	// The ID of a composite model on this asset.
	ComposedAssetModelId *string

	// The ID of the parent composite model in this asset model relationship.
	ParentAssetModelCompositeModelId *string

	noSmithyDocumentSerde
}

type CreateAssetModelCompositeModelOutput struct {

	// The ID of the composed asset model. You can use this ID when you call other IoT
	// SiteWise APIs.
	//
	// This member is required.
	AssetModelCompositeModelId *string

	// The path to the composite model listing the parent composite models.
	//
	// This member is required.
	AssetModelCompositeModelPath []types.AssetModelCompositeModelPathSegment

	// Contains current status information for an asset model. For more information,
	// see [Asset and model states]in the IoT SiteWise User Guide.
	//
	// [Asset and model states]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-and-model-states.html
	//
	// This member is required.
	AssetModelStatus *types.AssetModelStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateAssetModelCompositeModelMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateAssetModelCompositeModel{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateAssetModelCompositeModel{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateAssetModelCompositeModel"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addEndpointPrefix_opCreateAssetModelCompositeModelMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateAssetModelCompositeModelMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateAssetModelCompositeModelValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateAssetModelCompositeModel(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opCreateAssetModelCompositeModelMiddleware struct {
}

func (*endpointPrefix_opCreateAssetModelCompositeModelMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opCreateAssetModelCompositeModelMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "api." + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opCreateAssetModelCompositeModelMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opCreateAssetModelCompositeModelMiddleware{}, "ResolveEndpointV2", middleware.After)
}

type idempotencyToken_initializeOpCreateAssetModelCompositeModel struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateAssetModelCompositeModel) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateAssetModelCompositeModel) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateAssetModelCompositeModelInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateAssetModelCompositeModelInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateAssetModelCompositeModelMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateAssetModelCompositeModel{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateAssetModelCompositeModel(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateAssetModelCompositeModel",
	}
}
