// Code generated by smithy-go-codegen DO NOT EDIT.

package mediastore

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/mediastore/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the properties of all containers in AWS Elemental MediaStore. You can
// query to receive all the containers in one response. Or you can include the
// MaxResults parameter to receive a limited number of containers in each response.
// In this case, the response includes a token. To get the next set of containers,
// send the command again, this time with the NextToken parameter (with the
// returned token as its value). The next set of responses appears, with a token if
// there are still more containers to receive. See also DescribeContainer , which
// gets the properties of one container.
func (c *Client) ListContainers(ctx context.Context, params *ListContainersInput, optFns ...func(*Options)) (*ListContainersOutput, error) {
	if params == nil {
		params = &ListContainersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListContainers", params, optFns, c.addOperationListContainersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListContainersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListContainersInput struct {

	// Enter the maximum number of containers in the response. Use from 1 to 255
	// characters.
	MaxResults *int32

	// Only if you used MaxResults in the first command, enter the token (which was
	// included in the previous response) to obtain the next set of containers. This
	// token is included in a response only if there actually are more containers to
	// list.
	NextToken *string

	noSmithyDocumentSerde
}

type ListContainersOutput struct {

	// The names of the containers.
	//
	// This member is required.
	Containers []types.Container

	// NextToken is the token to use in the next call to ListContainers . This token is
	// returned only if you included the MaxResults tag in the original command, and
	// only if there are still containers to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListContainersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListContainers{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListContainers{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListContainers"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListContainers(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListContainersAPIClient is a client that implements the ListContainers
// operation.
type ListContainersAPIClient interface {
	ListContainers(context.Context, *ListContainersInput, ...func(*Options)) (*ListContainersOutput, error)
}

var _ ListContainersAPIClient = (*Client)(nil)

// ListContainersPaginatorOptions is the paginator options for ListContainers
type ListContainersPaginatorOptions struct {
	// Enter the maximum number of containers in the response. Use from 1 to 255
	// characters.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListContainersPaginator is a paginator for ListContainers
type ListContainersPaginator struct {
	options   ListContainersPaginatorOptions
	client    ListContainersAPIClient
	params    *ListContainersInput
	nextToken *string
	firstPage bool
}

// NewListContainersPaginator returns a new ListContainersPaginator
func NewListContainersPaginator(client ListContainersAPIClient, params *ListContainersInput, optFns ...func(*ListContainersPaginatorOptions)) *ListContainersPaginator {
	if params == nil {
		params = &ListContainersInput{}
	}

	options := ListContainersPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListContainersPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListContainersPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListContainers page.
func (p *ListContainersPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListContainersOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListContainers(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListContainers(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListContainers",
	}
}
