// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Provides a list of properties for the requested lineage group. For more
// information, see  Cross-Account Lineage Tracking
// (https://docs.aws.amazon.com/sagemaker/latest/dg/xaccount-lineage-tracking.html)
// in the Amazon SageMaker Developer Guide.
func (c *Client) DescribeLineageGroup(ctx context.Context, params *DescribeLineageGroupInput, optFns ...func(*Options)) (*DescribeLineageGroupOutput, error) {
	if params == nil {
		params = &DescribeLineageGroupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeLineageGroup", params, optFns, c.addOperationDescribeLineageGroupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeLineageGroupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeLineageGroupInput struct {

	// The name of the lineage group.
	//
	// This member is required.
	LineageGroupName *string

	noSmithyDocumentSerde
}

type DescribeLineageGroupOutput struct {

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, or project.
	CreatedBy *types.UserContext

	// The creation time of lineage group.
	CreationTime *time.Time

	// The description of the lineage group.
	Description *string

	// The display name of the lineage group.
	DisplayName *string

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, or project.
	LastModifiedBy *types.UserContext

	// The last modified time of the lineage group.
	LastModifiedTime *time.Time

	// The Amazon Resource Name (ARN) of the lineage group.
	LineageGroupArn *string

	// The name of the lineage group.
	LineageGroupName *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeLineageGroupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeLineageGroup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeLineageGroup{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeLineageGroupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeLineageGroup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeLineageGroup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "sagemaker",
		OperationName: "DescribeLineageGroup",
	}
}
