// Code generated by smithy-go-codegen DO NOT EDIT.

package drs

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/drs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates a LaunchConfiguration by Source Server ID.
func (c *Client) UpdateLaunchConfiguration(ctx context.Context, params *UpdateLaunchConfigurationInput, optFns ...func(*Options)) (*UpdateLaunchConfigurationOutput, error) {
	if params == nil {
		params = &UpdateLaunchConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateLaunchConfiguration", params, optFns, c.addOperationUpdateLaunchConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateLaunchConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateLaunchConfigurationInput struct {

	// The ID of the Source Server that we want to retrieve a Launch Configuration for.
	//
	// This member is required.
	SourceServerID *string

	// Whether we should copy the Private IP of the Source Server to the Recovery
	// Instance.
	CopyPrivateIp *bool

	// Whether we want to copy the tags of the Source Server to the EC2 machine of the
	// Recovery Instance.
	CopyTags *bool

	// The state of the Recovery Instance in EC2 after the recovery operation.
	LaunchDisposition types.LaunchDisposition

	// The licensing configuration to be used for this launch configuration.
	Licensing *types.Licensing

	// The name of the launch configuration.
	Name *string

	// Whether Elastic Disaster Recovery should try to automatically choose the
	// instance type that best matches the OS, CPU, and RAM of your Source Server.
	TargetInstanceTypeRightSizingMethod types.TargetInstanceTypeRightSizingMethod

	noSmithyDocumentSerde
}

type UpdateLaunchConfigurationOutput struct {

	// Whether we should copy the Private IP of the Source Server to the Recovery
	// Instance.
	CopyPrivateIp *bool

	// Whether we want to copy the tags of the Source Server to the EC2 machine of the
	// Recovery Instance.
	CopyTags *bool

	// The EC2 launch template ID of this launch configuration.
	Ec2LaunchTemplateID *string

	// The state of the Recovery Instance in EC2 after the recovery operation.
	LaunchDisposition types.LaunchDisposition

	// The licensing configuration to be used for this launch configuration.
	Licensing *types.Licensing

	// The name of the launch configuration.
	Name *string

	// The ID of the Source Server for this launch configuration.
	SourceServerID *string

	// Whether Elastic Disaster Recovery should try to automatically choose the
	// instance type that best matches the OS, CPU, and RAM of your Source Server.
	TargetInstanceTypeRightSizingMethod types.TargetInstanceTypeRightSizingMethod

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateLaunchConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateLaunchConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateLaunchConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateLaunchConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateLaunchConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateLaunchConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "drs",
		OperationName: "UpdateLaunchConfiguration",
	}
}
