package types

//go:generate stringer -type=Error

// Error is any error generated by the PacketConn. Note that other errors may still be returned, if e.g. HandleConn returns due to a network error. An Error may be wrapped to provide additional context.
type Error uint

const (
	ErrUndefined Error = iota
	ErrEncode
	ErrDecode
	ErrClosed
	ErrTimeout
	ErrBadMessage
	ErrEmptyMessage
	ErrOversizedMessage
	ErrUnrecognizedMessage
	ErrPeerNotFound
	ErrBadAddress
	ErrBadKey
)

func (e Error) Error() string {
	return e.String()
}
