/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */

/* This file is automatically generated using bindtool */

#include <pybind11/complex.h>
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

#include <gnuradio/qtgui/utils.h>
#include <qwt_legend.h>
#include <qwt_painter.h>
#include <qwt_plot.h>
#include <qwt_plot_canvas.h>
#include <qwt_plot_curve.h>
#include <qwt_plot_magnifier.h>
#include <qwt_plot_marker.h>
#include <qwt_plot_panner.h>
#include <qwt_plot_zoomer.h>
#include <qwt_scale_engine.h>
#include <qwt_scale_widget.h>
#include <qwt_symbol.h>

#include <gnuradio/qtgui/ber_sink_b.h>
// pydoc.h is automatically generated in the build directory
#include <ber_sink_b_pydoc.h>

void bind_ber_sink_b(py::module& m)
{

    using ber_sink_b = ::gr::qtgui::ber_sink_b;


    py::class_<ber_sink_b, gr::block, gr::basic_block, std::shared_ptr<ber_sink_b>>(
        m, "ber_sink_b", D(ber_sink_b))

        .def(py::init(&ber_sink_b::make),
             py::arg("esnos"),
             py::arg("curves") = 1,
             py::arg("berminerrors") = 100,
             py::arg("berLimit") = -7.,
             py::arg("curvenames") = std::vector<std::string>(),
             py::arg("parent") = nullptr,
             D(ber_sink_b, make))


        .def("exec_", &ber_sink_b::exec_, D(ber_sink_b, exec_))


        .def(
            "qwidget",
            [](ber_sink_b& self) { return reinterpret_cast<uintptr_t>(self.qwidget()); },
            D(ber_sink_b, qwidget))


        .def("set_y_axis",
             &ber_sink_b::set_y_axis,
             py::arg("min"),
             py::arg("max"),
             D(ber_sink_b, set_y_axis))


        .def("set_x_axis",
             &ber_sink_b::set_x_axis,
             py::arg("min"),
             py::arg("max"),
             D(ber_sink_b, set_x_axis))


        .def("set_update_time",
             &ber_sink_b::set_update_time,
             py::arg("t"),
             D(ber_sink_b, set_update_time))


        .def("set_title",
             &ber_sink_b::set_title,
             py::arg("title"),
             D(ber_sink_b, set_title))


        .def("set_line_label",
             &ber_sink_b::set_line_label,
             py::arg("which"),
             py::arg("label"),
             D(ber_sink_b, set_line_label))


        .def("set_line_color",
             &ber_sink_b::set_line_color,
             py::arg("which"),
             py::arg("color"),
             D(ber_sink_b, set_line_color))


        .def("set_line_width",
             &ber_sink_b::set_line_width,
             py::arg("which"),
             py::arg("width"),
             D(ber_sink_b, set_line_width))


        .def("set_line_style",
             &ber_sink_b::set_line_style,
             py::arg("which"),
             py::arg("style"),
             D(ber_sink_b, set_line_style))


        .def("set_line_marker",
             &ber_sink_b::set_line_marker,
             py::arg("which"),
             py::arg("marker"),
             D(ber_sink_b, set_line_marker))


        .def("set_line_alpha",
             &ber_sink_b::set_line_alpha,
             py::arg("which"),
             py::arg("alpha"),
             D(ber_sink_b, set_line_alpha))


        .def("title", &ber_sink_b::title, D(ber_sink_b, title))


        .def("line_label",
             &ber_sink_b::line_label,
             py::arg("which"),
             D(ber_sink_b, line_label))


        .def("line_color",
             &ber_sink_b::line_color,
             py::arg("which"),
             D(ber_sink_b, line_color))


        .def("line_width",
             &ber_sink_b::line_width,
             py::arg("which"),
             D(ber_sink_b, line_width))


        .def("line_style",
             &ber_sink_b::line_style,
             py::arg("which"),
             D(ber_sink_b, line_style))


        .def("line_marker",
             &ber_sink_b::line_marker,
             py::arg("which"),
             D(ber_sink_b, line_marker))


        .def("line_alpha",
             &ber_sink_b::line_alpha,
             py::arg("which"),
             D(ber_sink_b, line_alpha))


        .def("set_size",
             &ber_sink_b::set_size,
             py::arg("width"),
             py::arg("height"),
             D(ber_sink_b, set_size))


        .def("enable_menu",
             &ber_sink_b::enable_menu,
             py::arg("en") = true,
             D(ber_sink_b, enable_menu))


        .def("enable_autoscale",
             &ber_sink_b::enable_autoscale,
             py::arg("en"),
             D(ber_sink_b, enable_autoscale))


        .def("nsamps", &ber_sink_b::nsamps, D(ber_sink_b, nsamps))

        ;
}
