/* SqliteUtils.c generated by valac 0.34.4, the Vala compiler
 * generated from SqliteUtils.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))



gchar* dvb_database_sqlite_utils_escape (const gchar* text);
gchar* dvb_database_sqlite_utils_unescape (const gchar* text);


/**
     * Replace "'" with "''"
     */
gchar* dvb_database_sqlite_utils_escape (const gchar* text) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	GRegex* regex = NULL;
	gchar* escaped_str = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = text;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	{
		GRegex* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		_tmp3_ = g_regex_new ("'", G_REGEX_MULTILINE, 0, &_inner_error_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp4_ = _tmp2_;
		_tmp2_ = NULL;
		_g_regex_unref0 (regex);
		regex = _tmp4_;
		_g_regex_unref0 (_tmp2_);
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("SqliteUtils.vala:36: RegexError: %s", _tmp6_);
		_tmp7_ = text;
		_tmp8_ = g_strdup (_tmp7_);
		result = _tmp8_;
		_g_error_free0 (e);
		_g_regex_unref0 (regex);
		return result;
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		gchar* _tmp9_ = NULL;
		GRegex* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		_tmp10_ = regex;
		_tmp11_ = text;
		_tmp12_ = g_regex_replace_literal (_tmp10_, _tmp11_, (gssize) -1, 0, "''", 0, &_inner_error_);
		_tmp9_ = _tmp12_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			_g_free0 (escaped_str);
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp13_ = _tmp9_;
		_tmp9_ = NULL;
		_g_free0 (escaped_str);
		escaped_str = _tmp13_;
		_g_free0 (_tmp9_);
	}
	goto __finally5;
	__catch5_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("SqliteUtils.vala:45: RegexError: %s", _tmp15_);
		_tmp16_ = text;
		_tmp17_ = g_strdup (_tmp16_);
		result = _tmp17_;
		_g_error_free0 (e);
		_g_free0 (escaped_str);
		_g_regex_unref0 (regex);
		return result;
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (escaped_str);
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = escaped_str;
	_g_regex_unref0 (regex);
	return result;
}


/**
     * Replace "''" with "'"
     */
gchar* dvb_database_sqlite_utils_unescape (const gchar* text) {
	gchar* result = NULL;
	GRegex* regex = NULL;
	gchar* new_str = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (text != NULL, NULL);
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_ = NULL;
		GRegex* _tmp2_ = NULL;
		_tmp1_ = g_regex_new ("''", G_REGEX_MULTILINE, 0, &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch6_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (regex);
		regex = _tmp2_;
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally6;
	__catch6_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("SqliteUtils.vala:62: RegexError: %s", _tmp4_);
		_tmp5_ = text;
		_tmp6_ = g_strdup (_tmp5_);
		result = _tmp6_;
		_g_error_free0 (e);
		_g_regex_unref0 (regex);
		return result;
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp8_ = regex;
		_tmp9_ = text;
		_tmp10_ = g_regex_replace_literal (_tmp8_, _tmp9_, (gssize) -1, 0, "'", 0, &_inner_error_);
		_tmp7_ = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch7_g_regex_error;
			}
			_g_free0 (new_str);
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp11_ = _tmp7_;
		_tmp7_ = NULL;
		_g_free0 (new_str);
		new_str = _tmp11_;
		_g_free0 (_tmp7_);
	}
	goto __finally7;
	__catch7_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("SqliteUtils.vala:71: RegexError: %s", _tmp13_);
		_tmp14_ = text;
		_tmp15_ = g_strdup (_tmp14_);
		result = _tmp15_;
		_g_error_free0 (e);
		_g_free0 (new_str);
		_g_regex_unref0 (regex);
		return result;
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (new_str);
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = new_str;
	_g_regex_unref0 (regex);
	return result;
}



