// Code generated by smithy-go-codegen DO NOT EDIT.

package privatenetworks

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/privatenetworks/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Activates the specified network site.
func (c *Client) ActivateNetworkSite(ctx context.Context, params *ActivateNetworkSiteInput, optFns ...func(*Options)) (*ActivateNetworkSiteOutput, error) {
	if params == nil {
		params = &ActivateNetworkSiteInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ActivateNetworkSite", params, optFns, c.addOperationActivateNetworkSiteMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ActivateNetworkSiteOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ActivateNetworkSiteInput struct {

	// The Amazon Resource Name (ARN) of the network site.
	//
	// This member is required.
	NetworkSiteArn *string

	// The shipping address of the network site.
	//
	// This member is required.
	ShippingAddress *types.Address

	// Unique, case-sensitive identifier that you provide to ensure the idempotency of
	// the request. For more information, see [How to ensure idempotency].
	//
	// [How to ensure idempotency]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html
	ClientToken *string

	// Determines the duration and renewal status of the commitment period for all
	// pending radio units.
	//
	// If you include commitmentConfiguration in the ActivateNetworkSiteRequest
	// action, you must specify the following:
	//
	//   - The commitment period for the radio unit. You can choose a 60-day, 1-year,
	//   or 3-year period.
	//
	//   - Whether you want your commitment period to automatically renew for one more
	//   year after your current commitment period expires.
	//
	// For pricing, see [Amazon Web Services Private 5G Pricing].
	//
	// If you do not include commitmentConfiguration in the ActivateNetworkSiteRequest
	// action, the commitment period is set to 60-days.
	//
	// [Amazon Web Services Private 5G Pricing]: http://aws.amazon.com/private5g/pricing
	CommitmentConfiguration *types.CommitmentConfiguration

	noSmithyDocumentSerde
}

type ActivateNetworkSiteOutput struct {

	// Information about the network site.
	NetworkSite *types.NetworkSite

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationActivateNetworkSiteMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpActivateNetworkSite{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpActivateNetworkSite{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ActivateNetworkSite"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpActivateNetworkSiteValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opActivateNetworkSite(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opActivateNetworkSite(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ActivateNetworkSite",
	}
}
