// Code generated by smithy-go-codegen DO NOT EDIT.

package pi

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/pi/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieve the dimensions that can be queried for each specified metric type on a
// specified DB instance.
func (c *Client) ListAvailableResourceDimensions(ctx context.Context, params *ListAvailableResourceDimensionsInput, optFns ...func(*Options)) (*ListAvailableResourceDimensionsOutput, error) {
	if params == nil {
		params = &ListAvailableResourceDimensionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAvailableResourceDimensions", params, optFns, c.addOperationListAvailableResourceDimensionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAvailableResourceDimensionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAvailableResourceDimensionsInput struct {

	// An immutable identifier for a data source that is unique within an Amazon Web
	// Services Region. Performance Insights gathers metrics from this data source. To
	// use an Amazon RDS DB instance as a data source, specify its DbiResourceId
	// value. For example, specify db-ABCDEFGHIJKLMNOPQRSTU1VWZ .
	//
	// This member is required.
	Identifier *string

	// The types of metrics for which to retrieve dimensions. Valid values include
	// db.load .
	//
	// This member is required.
	Metrics []string

	// The Amazon Web Services service for which Performance Insights returns metrics.
	//
	// This member is required.
	ServiceType types.ServiceType

	// The actions to discover the dimensions you are authorized to access. If you
	// specify multiple actions, then the response will contain the dimensions common
	// for all the actions.
	//
	// When you don't specify this request parameter or provide an empty list, the
	// response contains all the available dimensions for the target database engine
	// whether or not you are authorized to access them.
	AuthorizedActions []types.FineGrainedAction

	// The maximum number of items to return in the response. If more items exist than
	// the specified MaxRecords value, a pagination token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int32

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the token, up to the
	// value specified by MaxRecords .
	NextToken *string

	noSmithyDocumentSerde
}

type ListAvailableResourceDimensionsOutput struct {

	// The dimension information returned for requested metric types.
	MetricDimensions []types.MetricDimensionGroups

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the token, up to the
	// value specified by MaxRecords .
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAvailableResourceDimensionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListAvailableResourceDimensions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListAvailableResourceDimensions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAvailableResourceDimensions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListAvailableResourceDimensionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAvailableResourceDimensions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListAvailableResourceDimensionsAPIClient is a client that implements the
// ListAvailableResourceDimensions operation.
type ListAvailableResourceDimensionsAPIClient interface {
	ListAvailableResourceDimensions(context.Context, *ListAvailableResourceDimensionsInput, ...func(*Options)) (*ListAvailableResourceDimensionsOutput, error)
}

var _ ListAvailableResourceDimensionsAPIClient = (*Client)(nil)

// ListAvailableResourceDimensionsPaginatorOptions is the paginator options for
// ListAvailableResourceDimensions
type ListAvailableResourceDimensionsPaginatorOptions struct {
	// The maximum number of items to return in the response. If more items exist than
	// the specified MaxRecords value, a pagination token is included in the response
	// so that the remaining results can be retrieved.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAvailableResourceDimensionsPaginator is a paginator for
// ListAvailableResourceDimensions
type ListAvailableResourceDimensionsPaginator struct {
	options   ListAvailableResourceDimensionsPaginatorOptions
	client    ListAvailableResourceDimensionsAPIClient
	params    *ListAvailableResourceDimensionsInput
	nextToken *string
	firstPage bool
}

// NewListAvailableResourceDimensionsPaginator returns a new
// ListAvailableResourceDimensionsPaginator
func NewListAvailableResourceDimensionsPaginator(client ListAvailableResourceDimensionsAPIClient, params *ListAvailableResourceDimensionsInput, optFns ...func(*ListAvailableResourceDimensionsPaginatorOptions)) *ListAvailableResourceDimensionsPaginator {
	if params == nil {
		params = &ListAvailableResourceDimensionsInput{}
	}

	options := ListAvailableResourceDimensionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAvailableResourceDimensionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAvailableResourceDimensionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAvailableResourceDimensions page.
func (p *ListAvailableResourceDimensionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAvailableResourceDimensionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListAvailableResourceDimensions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListAvailableResourceDimensions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAvailableResourceDimensions",
	}
}
