//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdatashare

const (
	moduleName    = "armdatashare"
	moduleVersion = "v1.0.0"
)

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// DataSetKind - Kind of data set.
type DataSetKind string

const (
	DataSetKindAdlsGen1File                 DataSetKind = "AdlsGen1File"
	DataSetKindAdlsGen1Folder               DataSetKind = "AdlsGen1Folder"
	DataSetKindAdlsGen2File                 DataSetKind = "AdlsGen2File"
	DataSetKindAdlsGen2FileSystem           DataSetKind = "AdlsGen2FileSystem"
	DataSetKindAdlsGen2Folder               DataSetKind = "AdlsGen2Folder"
	DataSetKindBlob                         DataSetKind = "Blob"
	DataSetKindBlobFolder                   DataSetKind = "BlobFolder"
	DataSetKindContainer                    DataSetKind = "Container"
	DataSetKindKustoCluster                 DataSetKind = "KustoCluster"
	DataSetKindKustoDatabase                DataSetKind = "KustoDatabase"
	DataSetKindSQLDBTable                   DataSetKind = "SqlDBTable"
	DataSetKindSQLDWTable                   DataSetKind = "SqlDWTable"
	DataSetKindSynapseWorkspaceSQLPoolTable DataSetKind = "SynapseWorkspaceSqlPoolTable"
)

// PossibleDataSetKindValues returns the possible values for the DataSetKind const type.
func PossibleDataSetKindValues() []DataSetKind {
	return []DataSetKind{
		DataSetKindAdlsGen1File,
		DataSetKindAdlsGen1Folder,
		DataSetKindAdlsGen2File,
		DataSetKindAdlsGen2FileSystem,
		DataSetKindAdlsGen2Folder,
		DataSetKindBlob,
		DataSetKindBlobFolder,
		DataSetKindContainer,
		DataSetKindKustoCluster,
		DataSetKindKustoDatabase,
		DataSetKindSQLDBTable,
		DataSetKindSQLDWTable,
		DataSetKindSynapseWorkspaceSQLPoolTable,
	}
}

// DataSetMappingKind - Kind of data set mapping.
type DataSetMappingKind string

const (
	DataSetMappingKindAdlsGen2File                 DataSetMappingKind = "AdlsGen2File"
	DataSetMappingKindAdlsGen2FileSystem           DataSetMappingKind = "AdlsGen2FileSystem"
	DataSetMappingKindAdlsGen2Folder               DataSetMappingKind = "AdlsGen2Folder"
	DataSetMappingKindBlob                         DataSetMappingKind = "Blob"
	DataSetMappingKindBlobFolder                   DataSetMappingKind = "BlobFolder"
	DataSetMappingKindContainer                    DataSetMappingKind = "Container"
	DataSetMappingKindKustoCluster                 DataSetMappingKind = "KustoCluster"
	DataSetMappingKindKustoDatabase                DataSetMappingKind = "KustoDatabase"
	DataSetMappingKindSQLDBTable                   DataSetMappingKind = "SqlDBTable"
	DataSetMappingKindSQLDWTable                   DataSetMappingKind = "SqlDWTable"
	DataSetMappingKindSynapseWorkspaceSQLPoolTable DataSetMappingKind = "SynapseWorkspaceSqlPoolTable"
)

// PossibleDataSetMappingKindValues returns the possible values for the DataSetMappingKind const type.
func PossibleDataSetMappingKindValues() []DataSetMappingKind {
	return []DataSetMappingKind{
		DataSetMappingKindAdlsGen2File,
		DataSetMappingKindAdlsGen2FileSystem,
		DataSetMappingKindAdlsGen2Folder,
		DataSetMappingKindBlob,
		DataSetMappingKindBlobFolder,
		DataSetMappingKindContainer,
		DataSetMappingKindKustoCluster,
		DataSetMappingKindKustoDatabase,
		DataSetMappingKindSQLDBTable,
		DataSetMappingKindSQLDWTable,
		DataSetMappingKindSynapseWorkspaceSQLPoolTable,
	}
}

// DataSetMappingStatus - Gets the status of the data set mapping.
type DataSetMappingStatus string

const (
	DataSetMappingStatusBroken DataSetMappingStatus = "Broken"
	DataSetMappingStatusOk     DataSetMappingStatus = "Ok"
)

// PossibleDataSetMappingStatusValues returns the possible values for the DataSetMappingStatus const type.
func PossibleDataSetMappingStatusValues() []DataSetMappingStatus {
	return []DataSetMappingStatus{
		DataSetMappingStatusBroken,
		DataSetMappingStatusOk,
	}
}

// DataSetType - Type of data set
type DataSetType string

const (
	DataSetTypeAdlsGen1File                 DataSetType = "AdlsGen1File"
	DataSetTypeAdlsGen1Folder               DataSetType = "AdlsGen1Folder"
	DataSetTypeAdlsGen2File                 DataSetType = "AdlsGen2File"
	DataSetTypeAdlsGen2FileSystem           DataSetType = "AdlsGen2FileSystem"
	DataSetTypeAdlsGen2Folder               DataSetType = "AdlsGen2Folder"
	DataSetTypeBlob                         DataSetType = "Blob"
	DataSetTypeBlobFolder                   DataSetType = "BlobFolder"
	DataSetTypeContainer                    DataSetType = "Container"
	DataSetTypeKustoCluster                 DataSetType = "KustoCluster"
	DataSetTypeKustoDatabase                DataSetType = "KustoDatabase"
	DataSetTypeSQLDBTable                   DataSetType = "SqlDBTable"
	DataSetTypeSQLDWTable                   DataSetType = "SqlDWTable"
	DataSetTypeSynapseWorkspaceSQLPoolTable DataSetType = "SynapseWorkspaceSqlPoolTable"
)

// PossibleDataSetTypeValues returns the possible values for the DataSetType const type.
func PossibleDataSetTypeValues() []DataSetType {
	return []DataSetType{
		DataSetTypeAdlsGen1File,
		DataSetTypeAdlsGen1Folder,
		DataSetTypeAdlsGen2File,
		DataSetTypeAdlsGen2FileSystem,
		DataSetTypeAdlsGen2Folder,
		DataSetTypeBlob,
		DataSetTypeBlobFolder,
		DataSetTypeContainer,
		DataSetTypeKustoCluster,
		DataSetTypeKustoDatabase,
		DataSetTypeSQLDBTable,
		DataSetTypeSQLDWTable,
		DataSetTypeSynapseWorkspaceSQLPoolTable,
	}
}

// InvitationStatus - The status of the invitation.
type InvitationStatus string

const (
	InvitationStatusAccepted  InvitationStatus = "Accepted"
	InvitationStatusPending   InvitationStatus = "Pending"
	InvitationStatusRejected  InvitationStatus = "Rejected"
	InvitationStatusWithdrawn InvitationStatus = "Withdrawn"
)

// PossibleInvitationStatusValues returns the possible values for the InvitationStatus const type.
func PossibleInvitationStatusValues() []InvitationStatus {
	return []InvitationStatus{
		InvitationStatusAccepted,
		InvitationStatusPending,
		InvitationStatusRejected,
		InvitationStatusWithdrawn,
	}
}

// LastModifiedByType - The type of identity that last modified the resource.
type LastModifiedByType string

const (
	LastModifiedByTypeApplication     LastModifiedByType = "Application"
	LastModifiedByTypeKey             LastModifiedByType = "Key"
	LastModifiedByTypeManagedIdentity LastModifiedByType = "ManagedIdentity"
	LastModifiedByTypeUser            LastModifiedByType = "User"
)

// PossibleLastModifiedByTypeValues returns the possible values for the LastModifiedByType const type.
func PossibleLastModifiedByTypeValues() []LastModifiedByType {
	return []LastModifiedByType{
		LastModifiedByTypeApplication,
		LastModifiedByTypeKey,
		LastModifiedByTypeManagedIdentity,
		LastModifiedByTypeUser,
	}
}

// OutputType - Type of output file
type OutputType string

const (
	OutputTypeCSV     OutputType = "Csv"
	OutputTypeParquet OutputType = "Parquet"
)

// PossibleOutputTypeValues returns the possible values for the OutputType const type.
func PossibleOutputTypeValues() []OutputType {
	return []OutputType{
		OutputTypeCSV,
		OutputTypeParquet,
	}
}

// ProvisioningState - Provisioning state of the Account
type ProvisioningState string

const (
	ProvisioningStateCreating  ProvisioningState = "Creating"
	ProvisioningStateDeleting  ProvisioningState = "Deleting"
	ProvisioningStateFailed    ProvisioningState = "Failed"
	ProvisioningStateMoving    ProvisioningState = "Moving"
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns the possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{
		ProvisioningStateCreating,
		ProvisioningStateDeleting,
		ProvisioningStateFailed,
		ProvisioningStateMoving,
		ProvisioningStateSucceeded,
	}
}

// RecurrenceInterval - Recurrence Interval
type RecurrenceInterval string

const (
	RecurrenceIntervalDay  RecurrenceInterval = "Day"
	RecurrenceIntervalHour RecurrenceInterval = "Hour"
)

// PossibleRecurrenceIntervalValues returns the possible values for the RecurrenceInterval const type.
func PossibleRecurrenceIntervalValues() []RecurrenceInterval {
	return []RecurrenceInterval{
		RecurrenceIntervalDay,
		RecurrenceIntervalHour,
	}
}

// RegistrationStatus - Registration status
type RegistrationStatus string

const (
	RegistrationStatusActivated                   RegistrationStatus = "Activated"
	RegistrationStatusActivationAttemptsExhausted RegistrationStatus = "ActivationAttemptsExhausted"
	RegistrationStatusActivationPending           RegistrationStatus = "ActivationPending"
)

// PossibleRegistrationStatusValues returns the possible values for the RegistrationStatus const type.
func PossibleRegistrationStatusValues() []RegistrationStatus {
	return []RegistrationStatus{
		RegistrationStatusActivated,
		RegistrationStatusActivationAttemptsExhausted,
		RegistrationStatusActivationPending,
	}
}

// ShareKind - Share kind.
type ShareKind string

const (
	ShareKindCopyBased ShareKind = "CopyBased"
	ShareKindInPlace   ShareKind = "InPlace"
)

// PossibleShareKindValues returns the possible values for the ShareKind const type.
func PossibleShareKindValues() []ShareKind {
	return []ShareKind{
		ShareKindCopyBased,
		ShareKindInPlace,
	}
}

// ShareSubscriptionStatus - Gets the status of share subscription
type ShareSubscriptionStatus string

const (
	ShareSubscriptionStatusActive        ShareSubscriptionStatus = "Active"
	ShareSubscriptionStatusRevoked       ShareSubscriptionStatus = "Revoked"
	ShareSubscriptionStatusRevoking      ShareSubscriptionStatus = "Revoking"
	ShareSubscriptionStatusSourceDeleted ShareSubscriptionStatus = "SourceDeleted"
)

// PossibleShareSubscriptionStatusValues returns the possible values for the ShareSubscriptionStatus const type.
func PossibleShareSubscriptionStatusValues() []ShareSubscriptionStatus {
	return []ShareSubscriptionStatus{
		ShareSubscriptionStatusActive,
		ShareSubscriptionStatusRevoked,
		ShareSubscriptionStatusRevoking,
		ShareSubscriptionStatusSourceDeleted,
	}
}

// SourceShareSynchronizationSettingKind - Kind of synchronization setting on share.
type SourceShareSynchronizationSettingKind string

const (
	SourceShareSynchronizationSettingKindScheduleBased SourceShareSynchronizationSettingKind = "ScheduleBased"
)

// PossibleSourceShareSynchronizationSettingKindValues returns the possible values for the SourceShareSynchronizationSettingKind const type.
func PossibleSourceShareSynchronizationSettingKindValues() []SourceShareSynchronizationSettingKind {
	return []SourceShareSynchronizationSettingKind{
		SourceShareSynchronizationSettingKindScheduleBased,
	}
}

// Status - Operation state of the long running operation.
type Status string

const (
	StatusAccepted         Status = "Accepted"
	StatusCanceled         Status = "Canceled"
	StatusFailed           Status = "Failed"
	StatusInProgress       Status = "InProgress"
	StatusSucceeded        Status = "Succeeded"
	StatusTransientFailure Status = "TransientFailure"
)

// PossibleStatusValues returns the possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{
		StatusAccepted,
		StatusCanceled,
		StatusFailed,
		StatusInProgress,
		StatusSucceeded,
		StatusTransientFailure,
	}
}

// SynchronizationMode - Synchronization mode
type SynchronizationMode string

const (
	SynchronizationModeFullSync    SynchronizationMode = "FullSync"
	SynchronizationModeIncremental SynchronizationMode = "Incremental"
)

// PossibleSynchronizationModeValues returns the possible values for the SynchronizationMode const type.
func PossibleSynchronizationModeValues() []SynchronizationMode {
	return []SynchronizationMode{
		SynchronizationModeFullSync,
		SynchronizationModeIncremental,
	}
}

// SynchronizationSettingKind - Kind of synchronization setting.
type SynchronizationSettingKind string

const (
	SynchronizationSettingKindScheduleBased SynchronizationSettingKind = "ScheduleBased"
)

// PossibleSynchronizationSettingKindValues returns the possible values for the SynchronizationSettingKind const type.
func PossibleSynchronizationSettingKindValues() []SynchronizationSettingKind {
	return []SynchronizationSettingKind{
		SynchronizationSettingKindScheduleBased,
	}
}

// TriggerKind - Kind of synchronization on trigger.
type TriggerKind string

const (
	TriggerKindScheduleBased TriggerKind = "ScheduleBased"
)

// PossibleTriggerKindValues returns the possible values for the TriggerKind const type.
func PossibleTriggerKindValues() []TriggerKind {
	return []TriggerKind{
		TriggerKindScheduleBased,
	}
}

// TriggerStatus - Gets the trigger state
type TriggerStatus string

const (
	TriggerStatusActive                              TriggerStatus = "Active"
	TriggerStatusInactive                            TriggerStatus = "Inactive"
	TriggerStatusSourceSynchronizationSettingDeleted TriggerStatus = "SourceSynchronizationSettingDeleted"
)

// PossibleTriggerStatusValues returns the possible values for the TriggerStatus const type.
func PossibleTriggerStatusValues() []TriggerStatus {
	return []TriggerStatus{
		TriggerStatusActive,
		TriggerStatusInactive,
		TriggerStatusSourceSynchronizationSettingDeleted,
	}
}

// Type - Identity Type
type Type string

const (
	TypeSystemAssigned Type = "SystemAssigned"
)

// PossibleTypeValues returns the possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{
		TypeSystemAssigned,
	}
}
