//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappservice

const (
	moduleName    = "armappservice"
	moduleVersion = "v2.0.0"
)

// ActiveRevisionsMode - ActiveRevisionsMode controls how active revisions are handled for the Container app:Multiple: multiple
// revisions can be active. If no value if provided, this is the defaultSingle: Only one revision
// can be active at a time. Revision weights can not be used in this mode
type ActiveRevisionsMode string

const (
	ActiveRevisionsModeMultiple ActiveRevisionsMode = "multiple"
	ActiveRevisionsModeSingle   ActiveRevisionsMode = "single"
)

// PossibleActiveRevisionsModeValues returns the possible values for the ActiveRevisionsMode const type.
func PossibleActiveRevisionsModeValues() []ActiveRevisionsMode {
	return []ActiveRevisionsMode{
		ActiveRevisionsModeMultiple,
		ActiveRevisionsModeSingle,
	}
}

// AppServicePlanRestrictions - App Service plans this offer is restricted to.
type AppServicePlanRestrictions string

const (
	AppServicePlanRestrictionsNone     AppServicePlanRestrictions = "None"
	AppServicePlanRestrictionsFree     AppServicePlanRestrictions = "Free"
	AppServicePlanRestrictionsShared   AppServicePlanRestrictions = "Shared"
	AppServicePlanRestrictionsBasic    AppServicePlanRestrictions = "Basic"
	AppServicePlanRestrictionsStandard AppServicePlanRestrictions = "Standard"
	AppServicePlanRestrictionsPremium  AppServicePlanRestrictions = "Premium"
)

// PossibleAppServicePlanRestrictionsValues returns the possible values for the AppServicePlanRestrictions const type.
func PossibleAppServicePlanRestrictionsValues() []AppServicePlanRestrictions {
	return []AppServicePlanRestrictions{
		AppServicePlanRestrictionsNone,
		AppServicePlanRestrictionsFree,
		AppServicePlanRestrictionsShared,
		AppServicePlanRestrictionsBasic,
		AppServicePlanRestrictionsStandard,
		AppServicePlanRestrictionsPremium,
	}
}

// AutoHealActionType - Predefined action to be taken.
type AutoHealActionType string

const (
	AutoHealActionTypeRecycle      AutoHealActionType = "Recycle"
	AutoHealActionTypeLogEvent     AutoHealActionType = "LogEvent"
	AutoHealActionTypeCustomAction AutoHealActionType = "CustomAction"
)

// PossibleAutoHealActionTypeValues returns the possible values for the AutoHealActionType const type.
func PossibleAutoHealActionTypeValues() []AutoHealActionType {
	return []AutoHealActionType{
		AutoHealActionTypeRecycle,
		AutoHealActionTypeLogEvent,
		AutoHealActionTypeCustomAction,
	}
}

// AzureResourceType - Type of the Azure resource the hostname is assigned to.
type AzureResourceType string

const (
	AzureResourceTypeWebsite        AzureResourceType = "Website"
	AzureResourceTypeTrafficManager AzureResourceType = "TrafficManager"
)

// PossibleAzureResourceTypeValues returns the possible values for the AzureResourceType const type.
func PossibleAzureResourceTypeValues() []AzureResourceType {
	return []AzureResourceType{
		AzureResourceTypeWebsite,
		AzureResourceTypeTrafficManager,
	}
}

// AzureStorageState - State of the storage account.
type AzureStorageState string

const (
	AzureStorageStateOk                 AzureStorageState = "Ok"
	AzureStorageStateInvalidCredentials AzureStorageState = "InvalidCredentials"
	AzureStorageStateInvalidShare       AzureStorageState = "InvalidShare"
	AzureStorageStateNotValidated       AzureStorageState = "NotValidated"
)

// PossibleAzureStorageStateValues returns the possible values for the AzureStorageState const type.
func PossibleAzureStorageStateValues() []AzureStorageState {
	return []AzureStorageState{
		AzureStorageStateOk,
		AzureStorageStateInvalidCredentials,
		AzureStorageStateInvalidShare,
		AzureStorageStateNotValidated,
	}
}

// AzureStorageType - Type of storage.
type AzureStorageType string

const (
	AzureStorageTypeAzureFiles AzureStorageType = "AzureFiles"
	AzureStorageTypeAzureBlob  AzureStorageType = "AzureBlob"
)

// PossibleAzureStorageTypeValues returns the possible values for the AzureStorageType const type.
func PossibleAzureStorageTypeValues() []AzureStorageType {
	return []AzureStorageType{
		AzureStorageTypeAzureFiles,
		AzureStorageTypeAzureBlob,
	}
}

// BackupItemStatus - Backup status.
type BackupItemStatus string

const (
	BackupItemStatusInProgress         BackupItemStatus = "InProgress"
	BackupItemStatusFailed             BackupItemStatus = "Failed"
	BackupItemStatusSucceeded          BackupItemStatus = "Succeeded"
	BackupItemStatusTimedOut           BackupItemStatus = "TimedOut"
	BackupItemStatusCreated            BackupItemStatus = "Created"
	BackupItemStatusSkipped            BackupItemStatus = "Skipped"
	BackupItemStatusPartiallySucceeded BackupItemStatus = "PartiallySucceeded"
	BackupItemStatusDeleteInProgress   BackupItemStatus = "DeleteInProgress"
	BackupItemStatusDeleteFailed       BackupItemStatus = "DeleteFailed"
	BackupItemStatusDeleted            BackupItemStatus = "Deleted"
)

// PossibleBackupItemStatusValues returns the possible values for the BackupItemStatus const type.
func PossibleBackupItemStatusValues() []BackupItemStatus {
	return []BackupItemStatus{
		BackupItemStatusInProgress,
		BackupItemStatusFailed,
		BackupItemStatusSucceeded,
		BackupItemStatusTimedOut,
		BackupItemStatusCreated,
		BackupItemStatusSkipped,
		BackupItemStatusPartiallySucceeded,
		BackupItemStatusDeleteInProgress,
		BackupItemStatusDeleteFailed,
		BackupItemStatusDeleted,
	}
}

// BackupRestoreOperationType - Operation type.
type BackupRestoreOperationType string

const (
	BackupRestoreOperationTypeDefault    BackupRestoreOperationType = "Default"
	BackupRestoreOperationTypeClone      BackupRestoreOperationType = "Clone"
	BackupRestoreOperationTypeRelocation BackupRestoreOperationType = "Relocation"
	BackupRestoreOperationTypeSnapshot   BackupRestoreOperationType = "Snapshot"
	BackupRestoreOperationTypeCloudFS    BackupRestoreOperationType = "CloudFS"
)

// PossibleBackupRestoreOperationTypeValues returns the possible values for the BackupRestoreOperationType const type.
func PossibleBackupRestoreOperationTypeValues() []BackupRestoreOperationType {
	return []BackupRestoreOperationType{
		BackupRestoreOperationTypeDefault,
		BackupRestoreOperationTypeClone,
		BackupRestoreOperationTypeRelocation,
		BackupRestoreOperationTypeSnapshot,
		BackupRestoreOperationTypeCloudFS,
	}
}

// BuildStatus - The status of the static site build.
type BuildStatus string

const (
	BuildStatusDeleting             BuildStatus = "Deleting"
	BuildStatusDeploying            BuildStatus = "Deploying"
	BuildStatusDetached             BuildStatus = "Detached"
	BuildStatusFailed               BuildStatus = "Failed"
	BuildStatusReady                BuildStatus = "Ready"
	BuildStatusUploading            BuildStatus = "Uploading"
	BuildStatusWaitingForDeployment BuildStatus = "WaitingForDeployment"
)

// PossibleBuildStatusValues returns the possible values for the BuildStatus const type.
func PossibleBuildStatusValues() []BuildStatus {
	return []BuildStatus{
		BuildStatusDeleting,
		BuildStatusDeploying,
		BuildStatusDetached,
		BuildStatusFailed,
		BuildStatusReady,
		BuildStatusUploading,
		BuildStatusWaitingForDeployment,
	}
}

// BuiltInAuthenticationProvider - The default authentication provider to use when multiple providers are configured. This
// setting is only needed if multiple providers are configured and the unauthenticated client action is set to
// "RedirectToLoginPage".
type BuiltInAuthenticationProvider string

const (
	BuiltInAuthenticationProviderAzureActiveDirectory BuiltInAuthenticationProvider = "AzureActiveDirectory"
	BuiltInAuthenticationProviderFacebook             BuiltInAuthenticationProvider = "Facebook"
	BuiltInAuthenticationProviderGoogle               BuiltInAuthenticationProvider = "Google"
	BuiltInAuthenticationProviderMicrosoftAccount     BuiltInAuthenticationProvider = "MicrosoftAccount"
	BuiltInAuthenticationProviderTwitter              BuiltInAuthenticationProvider = "Twitter"
	BuiltInAuthenticationProviderGithub               BuiltInAuthenticationProvider = "Github"
)

// PossibleBuiltInAuthenticationProviderValues returns the possible values for the BuiltInAuthenticationProvider const type.
func PossibleBuiltInAuthenticationProviderValues() []BuiltInAuthenticationProvider {
	return []BuiltInAuthenticationProvider{
		BuiltInAuthenticationProviderAzureActiveDirectory,
		BuiltInAuthenticationProviderFacebook,
		BuiltInAuthenticationProviderGoogle,
		BuiltInAuthenticationProviderMicrosoftAccount,
		BuiltInAuthenticationProviderTwitter,
		BuiltInAuthenticationProviderGithub,
	}
}

// CertificateOrderActionType - Action type.
type CertificateOrderActionType string

const (
	CertificateOrderActionTypeCertificateIssued            CertificateOrderActionType = "CertificateIssued"
	CertificateOrderActionTypeCertificateOrderCanceled     CertificateOrderActionType = "CertificateOrderCanceled"
	CertificateOrderActionTypeCertificateOrderCreated      CertificateOrderActionType = "CertificateOrderCreated"
	CertificateOrderActionTypeCertificateRevoked           CertificateOrderActionType = "CertificateRevoked"
	CertificateOrderActionTypeDomainValidationComplete     CertificateOrderActionType = "DomainValidationComplete"
	CertificateOrderActionTypeFraudDetected                CertificateOrderActionType = "FraudDetected"
	CertificateOrderActionTypeOrgNameChange                CertificateOrderActionType = "OrgNameChange"
	CertificateOrderActionTypeOrgValidationComplete        CertificateOrderActionType = "OrgValidationComplete"
	CertificateOrderActionTypeSanDrop                      CertificateOrderActionType = "SanDrop"
	CertificateOrderActionTypeFraudCleared                 CertificateOrderActionType = "FraudCleared"
	CertificateOrderActionTypeCertificateExpired           CertificateOrderActionType = "CertificateExpired"
	CertificateOrderActionTypeCertificateExpirationWarning CertificateOrderActionType = "CertificateExpirationWarning"
	CertificateOrderActionTypeFraudDocumentationRequired   CertificateOrderActionType = "FraudDocumentationRequired"
	CertificateOrderActionTypeUnknown                      CertificateOrderActionType = "Unknown"
)

// PossibleCertificateOrderActionTypeValues returns the possible values for the CertificateOrderActionType const type.
func PossibleCertificateOrderActionTypeValues() []CertificateOrderActionType {
	return []CertificateOrderActionType{
		CertificateOrderActionTypeCertificateIssued,
		CertificateOrderActionTypeCertificateOrderCanceled,
		CertificateOrderActionTypeCertificateOrderCreated,
		CertificateOrderActionTypeCertificateRevoked,
		CertificateOrderActionTypeDomainValidationComplete,
		CertificateOrderActionTypeFraudDetected,
		CertificateOrderActionTypeOrgNameChange,
		CertificateOrderActionTypeOrgValidationComplete,
		CertificateOrderActionTypeSanDrop,
		CertificateOrderActionTypeFraudCleared,
		CertificateOrderActionTypeCertificateExpired,
		CertificateOrderActionTypeCertificateExpirationWarning,
		CertificateOrderActionTypeFraudDocumentationRequired,
		CertificateOrderActionTypeUnknown,
	}
}

// CertificateOrderStatus - Current order status.
type CertificateOrderStatus string

const (
	CertificateOrderStatusPendingissuance   CertificateOrderStatus = "Pendingissuance"
	CertificateOrderStatusIssued            CertificateOrderStatus = "Issued"
	CertificateOrderStatusRevoked           CertificateOrderStatus = "Revoked"
	CertificateOrderStatusCanceled          CertificateOrderStatus = "Canceled"
	CertificateOrderStatusDenied            CertificateOrderStatus = "Denied"
	CertificateOrderStatusPendingrevocation CertificateOrderStatus = "Pendingrevocation"
	CertificateOrderStatusPendingRekey      CertificateOrderStatus = "PendingRekey"
	CertificateOrderStatusUnused            CertificateOrderStatus = "Unused"
	CertificateOrderStatusExpired           CertificateOrderStatus = "Expired"
	CertificateOrderStatusNotSubmitted      CertificateOrderStatus = "NotSubmitted"
)

// PossibleCertificateOrderStatusValues returns the possible values for the CertificateOrderStatus const type.
func PossibleCertificateOrderStatusValues() []CertificateOrderStatus {
	return []CertificateOrderStatus{
		CertificateOrderStatusPendingissuance,
		CertificateOrderStatusIssued,
		CertificateOrderStatusRevoked,
		CertificateOrderStatusCanceled,
		CertificateOrderStatusDenied,
		CertificateOrderStatusPendingrevocation,
		CertificateOrderStatusPendingRekey,
		CertificateOrderStatusUnused,
		CertificateOrderStatusExpired,
		CertificateOrderStatusNotSubmitted,
	}
}

// CertificateProductType - Certificate product type.
type CertificateProductType string

const (
	CertificateProductTypeStandardDomainValidatedSSL         CertificateProductType = "StandardDomainValidatedSsl"
	CertificateProductTypeStandardDomainValidatedWildCardSSL CertificateProductType = "StandardDomainValidatedWildCardSsl"
)

// PossibleCertificateProductTypeValues returns the possible values for the CertificateProductType const type.
func PossibleCertificateProductTypeValues() []CertificateProductType {
	return []CertificateProductType{
		CertificateProductTypeStandardDomainValidatedSSL,
		CertificateProductTypeStandardDomainValidatedWildCardSSL,
	}
}

// Channels - List of channels that this recommendation can apply.
type Channels string

const (
	ChannelsNotification Channels = "Notification"
	ChannelsAPI          Channels = "Api"
	ChannelsEmail        Channels = "Email"
	ChannelsWebhook      Channels = "Webhook"
	ChannelsAll          Channels = "All"
)

// PossibleChannelsValues returns the possible values for the Channels const type.
func PossibleChannelsValues() []Channels {
	return []Channels{
		ChannelsNotification,
		ChannelsAPI,
		ChannelsEmail,
		ChannelsWebhook,
		ChannelsAll,
	}
}

// CheckNameResourceTypes - Resource type used for verification.
type CheckNameResourceTypes string

const (
	CheckNameResourceTypesHostingEnvironment              CheckNameResourceTypes = "HostingEnvironment"
	CheckNameResourceTypesMicrosoftWebHostingEnvironments CheckNameResourceTypes = "Microsoft.Web/hostingEnvironments"
	CheckNameResourceTypesMicrosoftWebPublishingUsers     CheckNameResourceTypes = "Microsoft.Web/publishingUsers"
	CheckNameResourceTypesMicrosoftWebSites               CheckNameResourceTypes = "Microsoft.Web/sites"
	CheckNameResourceTypesMicrosoftWebSitesSlots          CheckNameResourceTypes = "Microsoft.Web/sites/slots"
	CheckNameResourceTypesPublishingUser                  CheckNameResourceTypes = "PublishingUser"
	CheckNameResourceTypesSite                            CheckNameResourceTypes = "Site"
	CheckNameResourceTypesSlot                            CheckNameResourceTypes = "Slot"
)

// PossibleCheckNameResourceTypesValues returns the possible values for the CheckNameResourceTypes const type.
func PossibleCheckNameResourceTypesValues() []CheckNameResourceTypes {
	return []CheckNameResourceTypes{
		CheckNameResourceTypesHostingEnvironment,
		CheckNameResourceTypesMicrosoftWebHostingEnvironments,
		CheckNameResourceTypesMicrosoftWebPublishingUsers,
		CheckNameResourceTypesMicrosoftWebSites,
		CheckNameResourceTypesMicrosoftWebSitesSlots,
		CheckNameResourceTypesPublishingUser,
		CheckNameResourceTypesSite,
		CheckNameResourceTypesSlot,
	}
}

// ClientCertMode - This composes with ClientCertEnabled setting.
// * ClientCertEnabled: false means ClientCert is ignored.
// * ClientCertEnabled: true and ClientCertMode: Required means ClientCert is required.
// * ClientCertEnabled: true and ClientCertMode: Optional means ClientCert is optional or accepted.
type ClientCertMode string

const (
	ClientCertModeRequired                ClientCertMode = "Required"
	ClientCertModeOptional                ClientCertMode = "Optional"
	ClientCertModeOptionalInteractiveUser ClientCertMode = "OptionalInteractiveUser"
)

// PossibleClientCertModeValues returns the possible values for the ClientCertMode const type.
func PossibleClientCertModeValues() []ClientCertMode {
	return []ClientCertMode{
		ClientCertModeRequired,
		ClientCertModeOptional,
		ClientCertModeOptionalInteractiveUser,
	}
}

// CloneAbilityResult - Name of app.
type CloneAbilityResult string

const (
	CloneAbilityResultCloneable          CloneAbilityResult = "Cloneable"
	CloneAbilityResultPartiallyCloneable CloneAbilityResult = "PartiallyCloneable"
	CloneAbilityResultNotCloneable       CloneAbilityResult = "NotCloneable"
)

// PossibleCloneAbilityResultValues returns the possible values for the CloneAbilityResult const type.
func PossibleCloneAbilityResultValues() []CloneAbilityResult {
	return []CloneAbilityResult{
		CloneAbilityResultCloneable,
		CloneAbilityResultPartiallyCloneable,
		CloneAbilityResultNotCloneable,
	}
}

// ComputeModeOptions - Shared/dedicated workers.
type ComputeModeOptions string

const (
	ComputeModeOptionsShared    ComputeModeOptions = "Shared"
	ComputeModeOptionsDedicated ComputeModeOptions = "Dedicated"
	ComputeModeOptionsDynamic   ComputeModeOptions = "Dynamic"
)

// PossibleComputeModeOptionsValues returns the possible values for the ComputeModeOptions const type.
func PossibleComputeModeOptionsValues() []ComputeModeOptions {
	return []ComputeModeOptions{
		ComputeModeOptionsShared,
		ComputeModeOptionsDedicated,
		ComputeModeOptionsDynamic,
	}
}

// ConnectionStringType - Type of database.
type ConnectionStringType string

const (
	ConnectionStringTypeMySQL           ConnectionStringType = "MySql"
	ConnectionStringTypeSQLServer       ConnectionStringType = "SQLServer"
	ConnectionStringTypeSQLAzure        ConnectionStringType = "SQLAzure"
	ConnectionStringTypeCustom          ConnectionStringType = "Custom"
	ConnectionStringTypeNotificationHub ConnectionStringType = "NotificationHub"
	ConnectionStringTypeServiceBus      ConnectionStringType = "ServiceBus"
	ConnectionStringTypeEventHub        ConnectionStringType = "EventHub"
	ConnectionStringTypeAPIHub          ConnectionStringType = "ApiHub"
	ConnectionStringTypeDocDb           ConnectionStringType = "DocDb"
	ConnectionStringTypeRedisCache      ConnectionStringType = "RedisCache"
	ConnectionStringTypePostgreSQL      ConnectionStringType = "PostgreSQL"
)

// PossibleConnectionStringTypeValues returns the possible values for the ConnectionStringType const type.
func PossibleConnectionStringTypeValues() []ConnectionStringType {
	return []ConnectionStringType{
		ConnectionStringTypeMySQL,
		ConnectionStringTypeSQLServer,
		ConnectionStringTypeSQLAzure,
		ConnectionStringTypeCustom,
		ConnectionStringTypeNotificationHub,
		ConnectionStringTypeServiceBus,
		ConnectionStringTypeEventHub,
		ConnectionStringTypeAPIHub,
		ConnectionStringTypeDocDb,
		ConnectionStringTypeRedisCache,
		ConnectionStringTypePostgreSQL,
	}
}

// ContainerAppProvisioningState - Provisioning state of the Container App.
type ContainerAppProvisioningState string

const (
	ContainerAppProvisioningStateCanceled   ContainerAppProvisioningState = "Canceled"
	ContainerAppProvisioningStateFailed     ContainerAppProvisioningState = "Failed"
	ContainerAppProvisioningStateInProgress ContainerAppProvisioningState = "InProgress"
	ContainerAppProvisioningStateSucceeded  ContainerAppProvisioningState = "Succeeded"
)

// PossibleContainerAppProvisioningStateValues returns the possible values for the ContainerAppProvisioningState const type.
func PossibleContainerAppProvisioningStateValues() []ContainerAppProvisioningState {
	return []ContainerAppProvisioningState{
		ContainerAppProvisioningStateCanceled,
		ContainerAppProvisioningStateFailed,
		ContainerAppProvisioningStateInProgress,
		ContainerAppProvisioningStateSucceeded,
	}
}

// ContinuousWebJobStatus - Job status.
type ContinuousWebJobStatus string

const (
	ContinuousWebJobStatusInitializing   ContinuousWebJobStatus = "Initializing"
	ContinuousWebJobStatusStarting       ContinuousWebJobStatus = "Starting"
	ContinuousWebJobStatusRunning        ContinuousWebJobStatus = "Running"
	ContinuousWebJobStatusPendingRestart ContinuousWebJobStatus = "PendingRestart"
	ContinuousWebJobStatusStopped        ContinuousWebJobStatus = "Stopped"
)

// PossibleContinuousWebJobStatusValues returns the possible values for the ContinuousWebJobStatus const type.
func PossibleContinuousWebJobStatusValues() []ContinuousWebJobStatus {
	return []ContinuousWebJobStatus{
		ContinuousWebJobStatusInitializing,
		ContinuousWebJobStatusStarting,
		ContinuousWebJobStatusRunning,
		ContinuousWebJobStatusPendingRestart,
		ContinuousWebJobStatusStopped,
	}
}

// CookieExpirationConvention - The convention used when determining the session cookie's expiration.
type CookieExpirationConvention string

const (
	CookieExpirationConventionFixedTime               CookieExpirationConvention = "FixedTime"
	CookieExpirationConventionIdentityProviderDerived CookieExpirationConvention = "IdentityProviderDerived"
)

// PossibleCookieExpirationConventionValues returns the possible values for the CookieExpirationConvention const type.
func PossibleCookieExpirationConventionValues() []CookieExpirationConvention {
	return []CookieExpirationConvention{
		CookieExpirationConventionFixedTime,
		CookieExpirationConventionIdentityProviderDerived,
	}
}

type CustomDNSSuffixProvisioningState string

const (
	CustomDNSSuffixProvisioningStateSucceeded  CustomDNSSuffixProvisioningState = "Succeeded"
	CustomDNSSuffixProvisioningStateFailed     CustomDNSSuffixProvisioningState = "Failed"
	CustomDNSSuffixProvisioningStateDegraded   CustomDNSSuffixProvisioningState = "Degraded"
	CustomDNSSuffixProvisioningStateInProgress CustomDNSSuffixProvisioningState = "InProgress"
)

// PossibleCustomDNSSuffixProvisioningStateValues returns the possible values for the CustomDNSSuffixProvisioningState const type.
func PossibleCustomDNSSuffixProvisioningStateValues() []CustomDNSSuffixProvisioningState {
	return []CustomDNSSuffixProvisioningState{
		CustomDNSSuffixProvisioningStateSucceeded,
		CustomDNSSuffixProvisioningStateFailed,
		CustomDNSSuffixProvisioningStateDegraded,
		CustomDNSSuffixProvisioningStateInProgress,
	}
}

// CustomDomainStatus - The status of the custom domain
type CustomDomainStatus string

const (
	CustomDomainStatusAdding                    CustomDomainStatus = "Adding"
	CustomDomainStatusDeleting                  CustomDomainStatus = "Deleting"
	CustomDomainStatusFailed                    CustomDomainStatus = "Failed"
	CustomDomainStatusReady                     CustomDomainStatus = "Ready"
	CustomDomainStatusRetrievingValidationToken CustomDomainStatus = "RetrievingValidationToken"
	CustomDomainStatusUnhealthy                 CustomDomainStatus = "Unhealthy"
	CustomDomainStatusValidating                CustomDomainStatus = "Validating"
)

// PossibleCustomDomainStatusValues returns the possible values for the CustomDomainStatus const type.
func PossibleCustomDomainStatusValues() []CustomDomainStatus {
	return []CustomDomainStatus{
		CustomDomainStatusAdding,
		CustomDomainStatusDeleting,
		CustomDomainStatusFailed,
		CustomDomainStatusReady,
		CustomDomainStatusRetrievingValidationToken,
		CustomDomainStatusUnhealthy,
		CustomDomainStatusValidating,
	}
}

// CustomHostNameDNSRecordType - Type of the DNS record.
type CustomHostNameDNSRecordType string

const (
	CustomHostNameDNSRecordTypeCName CustomHostNameDNSRecordType = "CName"
	CustomHostNameDNSRecordTypeA     CustomHostNameDNSRecordType = "A"
)

// PossibleCustomHostNameDNSRecordTypeValues returns the possible values for the CustomHostNameDNSRecordType const type.
func PossibleCustomHostNameDNSRecordTypeValues() []CustomHostNameDNSRecordType {
	return []CustomHostNameDNSRecordType{
		CustomHostNameDNSRecordTypeCName,
		CustomHostNameDNSRecordTypeA,
	}
}

// DNSType - Current DNS type
type DNSType string

const (
	DNSTypeAzureDNS                  DNSType = "AzureDns"
	DNSTypeDefaultDomainRegistrarDNS DNSType = "DefaultDomainRegistrarDns"
)

// PossibleDNSTypeValues returns the possible values for the DNSType const type.
func PossibleDNSTypeValues() []DNSType {
	return []DNSType{
		DNSTypeAzureDNS,
		DNSTypeDefaultDomainRegistrarDNS,
	}
}

// DNSVerificationTestResult - DNS verification test result.
type DNSVerificationTestResult string

const (
	DNSVerificationTestResultPassed  DNSVerificationTestResult = "Passed"
	DNSVerificationTestResultFailed  DNSVerificationTestResult = "Failed"
	DNSVerificationTestResultSkipped DNSVerificationTestResult = "Skipped"
)

// PossibleDNSVerificationTestResultValues returns the possible values for the DNSVerificationTestResult const type.
func PossibleDNSVerificationTestResultValues() []DNSVerificationTestResult {
	return []DNSVerificationTestResult{
		DNSVerificationTestResultPassed,
		DNSVerificationTestResultFailed,
		DNSVerificationTestResultSkipped,
	}
}

// DatabaseType - Database type (e.g. SqlAzure / MySql).
type DatabaseType string

const (
	DatabaseTypeLocalMySQL DatabaseType = "LocalMySql"
	DatabaseTypeMySQL      DatabaseType = "MySql"
	DatabaseTypePostgreSQL DatabaseType = "PostgreSql"
	DatabaseTypeSQLAzure   DatabaseType = "SqlAzure"
)

// PossibleDatabaseTypeValues returns the possible values for the DatabaseType const type.
func PossibleDatabaseTypeValues() []DatabaseType {
	return []DatabaseType{
		DatabaseTypeLocalMySQL,
		DatabaseTypeMySQL,
		DatabaseTypePostgreSQL,
		DatabaseTypeSQLAzure,
	}
}

// DayOfWeek - The day of the week.
type DayOfWeek string

const (
	DayOfWeekSunday    DayOfWeek = "Sunday"
	DayOfWeekMonday    DayOfWeek = "Monday"
	DayOfWeekTuesday   DayOfWeek = "Tuesday"
	DayOfWeekWednesday DayOfWeek = "Wednesday"
	DayOfWeekThursday  DayOfWeek = "Thursday"
	DayOfWeekFriday    DayOfWeek = "Friday"
	DayOfWeekSaturday  DayOfWeek = "Saturday"
)

// PossibleDayOfWeekValues returns the possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{
		DayOfWeekSunday,
		DayOfWeekMonday,
		DayOfWeekTuesday,
		DayOfWeekWednesday,
		DayOfWeekThursday,
		DayOfWeekFriday,
		DayOfWeekSaturday,
	}
}

type DaysOfWeek string

const (
	DaysOfWeekSunday    DaysOfWeek = "Sunday"
	DaysOfWeekMonday    DaysOfWeek = "Monday"
	DaysOfWeekTuesday   DaysOfWeek = "Tuesday"
	DaysOfWeekWednesday DaysOfWeek = "Wednesday"
	DaysOfWeekThursday  DaysOfWeek = "Thursday"
	DaysOfWeekFriday    DaysOfWeek = "Friday"
	DaysOfWeekSaturday  DaysOfWeek = "Saturday"
)

// PossibleDaysOfWeekValues returns the possible values for the DaysOfWeek const type.
func PossibleDaysOfWeekValues() []DaysOfWeek {
	return []DaysOfWeek{
		DaysOfWeekSunday,
		DaysOfWeekMonday,
		DaysOfWeekTuesday,
		DaysOfWeekWednesday,
		DaysOfWeekThursday,
		DaysOfWeekFriday,
		DaysOfWeekSaturday,
	}
}

// DeploymentBuildStatus - Deployment build status.
type DeploymentBuildStatus string

const (
	DeploymentBuildStatusBuildAborted             DeploymentBuildStatus = "BuildAborted"
	DeploymentBuildStatusBuildFailed              DeploymentBuildStatus = "BuildFailed"
	DeploymentBuildStatusBuildInProgress          DeploymentBuildStatus = "BuildInProgress"
	DeploymentBuildStatusBuildPending             DeploymentBuildStatus = "BuildPending"
	DeploymentBuildStatusBuildRequestReceived     DeploymentBuildStatus = "BuildRequestReceived"
	DeploymentBuildStatusBuildSuccessful          DeploymentBuildStatus = "BuildSuccessful"
	DeploymentBuildStatusPostBuildRestartRequired DeploymentBuildStatus = "PostBuildRestartRequired"
	DeploymentBuildStatusRuntimeFailed            DeploymentBuildStatus = "RuntimeFailed"
	DeploymentBuildStatusRuntimeStarting          DeploymentBuildStatus = "RuntimeStarting"
	DeploymentBuildStatusRuntimeSuccessful        DeploymentBuildStatus = "RuntimeSuccessful"
	DeploymentBuildStatusStartPolling             DeploymentBuildStatus = "StartPolling"
	DeploymentBuildStatusStartPollingWithRestart  DeploymentBuildStatus = "StartPollingWithRestart"
	DeploymentBuildStatusTimedOut                 DeploymentBuildStatus = "TimedOut"
)

// PossibleDeploymentBuildStatusValues returns the possible values for the DeploymentBuildStatus const type.
func PossibleDeploymentBuildStatusValues() []DeploymentBuildStatus {
	return []DeploymentBuildStatus{
		DeploymentBuildStatusBuildAborted,
		DeploymentBuildStatusBuildFailed,
		DeploymentBuildStatusBuildInProgress,
		DeploymentBuildStatusBuildPending,
		DeploymentBuildStatusBuildRequestReceived,
		DeploymentBuildStatusBuildSuccessful,
		DeploymentBuildStatusPostBuildRestartRequired,
		DeploymentBuildStatusRuntimeFailed,
		DeploymentBuildStatusRuntimeStarting,
		DeploymentBuildStatusRuntimeSuccessful,
		DeploymentBuildStatusStartPolling,
		DeploymentBuildStatusStartPollingWithRestart,
		DeploymentBuildStatusTimedOut,
	}
}

// DetectorType - Whether this detector is an Analysis Detector or not.
type DetectorType string

const (
	DetectorTypeDetector         DetectorType = "Detector"
	DetectorTypeAnalysis         DetectorType = "Analysis"
	DetectorTypeCategoryOverview DetectorType = "CategoryOverview"
)

// PossibleDetectorTypeValues returns the possible values for the DetectorType const type.
func PossibleDetectorTypeValues() []DetectorType {
	return []DetectorType{
		DetectorTypeDetector,
		DetectorTypeAnalysis,
		DetectorTypeCategoryOverview,
	}
}

// DomainStatus - Domain registration status.
type DomainStatus string

const (
	DomainStatusActive              DomainStatus = "Active"
	DomainStatusAwaiting            DomainStatus = "Awaiting"
	DomainStatusCancelled           DomainStatus = "Cancelled"
	DomainStatusConfiscated         DomainStatus = "Confiscated"
	DomainStatusDisabled            DomainStatus = "Disabled"
	DomainStatusExcluded            DomainStatus = "Excluded"
	DomainStatusExpired             DomainStatus = "Expired"
	DomainStatusFailed              DomainStatus = "Failed"
	DomainStatusHeld                DomainStatus = "Held"
	DomainStatusLocked              DomainStatus = "Locked"
	DomainStatusParked              DomainStatus = "Parked"
	DomainStatusPending             DomainStatus = "Pending"
	DomainStatusReserved            DomainStatus = "Reserved"
	DomainStatusReverted            DomainStatus = "Reverted"
	DomainStatusSuspended           DomainStatus = "Suspended"
	DomainStatusTransferred         DomainStatus = "Transferred"
	DomainStatusUnknown             DomainStatus = "Unknown"
	DomainStatusUnlocked            DomainStatus = "Unlocked"
	DomainStatusUnparked            DomainStatus = "Unparked"
	DomainStatusUpdated             DomainStatus = "Updated"
	DomainStatusJSONConverterFailed DomainStatus = "JsonConverterFailed"
)

// PossibleDomainStatusValues returns the possible values for the DomainStatus const type.
func PossibleDomainStatusValues() []DomainStatus {
	return []DomainStatus{
		DomainStatusActive,
		DomainStatusAwaiting,
		DomainStatusCancelled,
		DomainStatusConfiscated,
		DomainStatusDisabled,
		DomainStatusExcluded,
		DomainStatusExpired,
		DomainStatusFailed,
		DomainStatusHeld,
		DomainStatusLocked,
		DomainStatusParked,
		DomainStatusPending,
		DomainStatusReserved,
		DomainStatusReverted,
		DomainStatusSuspended,
		DomainStatusTransferred,
		DomainStatusUnknown,
		DomainStatusUnlocked,
		DomainStatusUnparked,
		DomainStatusUpdated,
		DomainStatusJSONConverterFailed,
	}
}

// DomainType - Valid values are Regular domain: Azure will charge the full price of domain registration, SoftDeleted: Purchasing
// this domain will simply restore it and this operation will not cost anything.
type DomainType string

const (
	DomainTypeRegular     DomainType = "Regular"
	DomainTypeSoftDeleted DomainType = "SoftDeleted"
)

// PossibleDomainTypeValues returns the possible values for the DomainType const type.
func PossibleDomainTypeValues() []DomainType {
	return []DomainType{
		DomainTypeRegular,
		DomainTypeSoftDeleted,
	}
}

// EnterpriseGradeCdnStatus - State indicating the status of the enterprise grade CDN serving traffic to the static web app.
type EnterpriseGradeCdnStatus string

const (
	EnterpriseGradeCdnStatusDisabled  EnterpriseGradeCdnStatus = "Disabled"
	EnterpriseGradeCdnStatusDisabling EnterpriseGradeCdnStatus = "Disabling"
	EnterpriseGradeCdnStatusEnabled   EnterpriseGradeCdnStatus = "Enabled"
	EnterpriseGradeCdnStatusEnabling  EnterpriseGradeCdnStatus = "Enabling"
)

// PossibleEnterpriseGradeCdnStatusValues returns the possible values for the EnterpriseGradeCdnStatus const type.
func PossibleEnterpriseGradeCdnStatusValues() []EnterpriseGradeCdnStatus {
	return []EnterpriseGradeCdnStatus{
		EnterpriseGradeCdnStatusDisabled,
		EnterpriseGradeCdnStatusDisabling,
		EnterpriseGradeCdnStatusEnabled,
		EnterpriseGradeCdnStatusEnabling,
	}
}

// ForwardProxyConvention - The convention used to determine the url of the request made.
type ForwardProxyConvention string

const (
	ForwardProxyConventionNoProxy  ForwardProxyConvention = "NoProxy"
	ForwardProxyConventionStandard ForwardProxyConvention = "Standard"
	ForwardProxyConventionCustom   ForwardProxyConvention = "Custom"
)

// PossibleForwardProxyConventionValues returns the possible values for the ForwardProxyConvention const type.
func PossibleForwardProxyConventionValues() []ForwardProxyConvention {
	return []ForwardProxyConvention{
		ForwardProxyConventionNoProxy,
		ForwardProxyConventionStandard,
		ForwardProxyConventionCustom,
	}
}

// FrequencyUnit - The unit of time for how often the backup should be executed (e.g. for weekly backup, this should be set
// to Day and FrequencyInterval should be set to 7)
type FrequencyUnit string

const (
	FrequencyUnitDay  FrequencyUnit = "Day"
	FrequencyUnitHour FrequencyUnit = "Hour"
)

// PossibleFrequencyUnitValues returns the possible values for the FrequencyUnit const type.
func PossibleFrequencyUnitValues() []FrequencyUnit {
	return []FrequencyUnit{
		FrequencyUnitDay,
		FrequencyUnitHour,
	}
}

type FrontEndServiceType string

const (
	FrontEndServiceTypeNodePort     FrontEndServiceType = "NodePort"
	FrontEndServiceTypeLoadBalancer FrontEndServiceType = "LoadBalancer"
)

// PossibleFrontEndServiceTypeValues returns the possible values for the FrontEndServiceType const type.
func PossibleFrontEndServiceTypeValues() []FrontEndServiceType {
	return []FrontEndServiceType{
		FrontEndServiceTypeNodePort,
		FrontEndServiceTypeLoadBalancer,
	}
}

// FtpsState - State of FTP / FTPS service
type FtpsState string

const (
	FtpsStateAllAllowed FtpsState = "AllAllowed"
	FtpsStateDisabled   FtpsState = "Disabled"
	FtpsStateFtpsOnly   FtpsState = "FtpsOnly"
)

// PossibleFtpsStateValues returns the possible values for the FtpsState const type.
func PossibleFtpsStateValues() []FtpsState {
	return []FtpsState{
		FtpsStateAllAllowed,
		FtpsStateDisabled,
		FtpsStateFtpsOnly,
	}
}

// HostNameType - Type of the hostname.
type HostNameType string

const (
	HostNameTypeVerified HostNameType = "Verified"
	HostNameTypeManaged  HostNameType = "Managed"
)

// PossibleHostNameTypeValues returns the possible values for the HostNameType const type.
func PossibleHostNameTypeValues() []HostNameType {
	return []HostNameType{
		HostNameTypeVerified,
		HostNameTypeManaged,
	}
}

// HostType - Indicates whether the hostname is a standard or repository hostname.
type HostType string

const (
	HostTypeStandard   HostType = "Standard"
	HostTypeRepository HostType = "Repository"
)

// PossibleHostTypeValues returns the possible values for the HostType const type.
func PossibleHostTypeValues() []HostType {
	return []HostType{
		HostTypeStandard,
		HostTypeRepository,
	}
}

// HostingEnvironmentStatus - Current status of the App Service Environment.
type HostingEnvironmentStatus string

const (
	HostingEnvironmentStatusPreparing HostingEnvironmentStatus = "Preparing"
	HostingEnvironmentStatusReady     HostingEnvironmentStatus = "Ready"
	HostingEnvironmentStatusScaling   HostingEnvironmentStatus = "Scaling"
	HostingEnvironmentStatusDeleting  HostingEnvironmentStatus = "Deleting"
)

// PossibleHostingEnvironmentStatusValues returns the possible values for the HostingEnvironmentStatus const type.
func PossibleHostingEnvironmentStatusValues() []HostingEnvironmentStatus {
	return []HostingEnvironmentStatus{
		HostingEnvironmentStatusPreparing,
		HostingEnvironmentStatusReady,
		HostingEnvironmentStatusScaling,
		HostingEnvironmentStatusDeleting,
	}
}

// IPFilterTag - Defines what this IP filter will be used for. This is to support IP filtering on proxies.
type IPFilterTag string

const (
	IPFilterTagDefault    IPFilterTag = "Default"
	IPFilterTagServiceTag IPFilterTag = "ServiceTag"
	IPFilterTagXffProxy   IPFilterTag = "XffProxy"
)

// PossibleIPFilterTagValues returns the possible values for the IPFilterTag const type.
func PossibleIPFilterTagValues() []IPFilterTag {
	return []IPFilterTag{
		IPFilterTagDefault,
		IPFilterTagServiceTag,
		IPFilterTagXffProxy,
	}
}

// InAvailabilityReasonType - Invalid indicates the name provided does not match Azure App Service naming requirements. AlreadyExists
// indicates that the name is already in use and is therefore unavailable.
type InAvailabilityReasonType string

const (
	InAvailabilityReasonTypeAlreadyExists InAvailabilityReasonType = "AlreadyExists"
	InAvailabilityReasonTypeInvalid       InAvailabilityReasonType = "Invalid"
)

// PossibleInAvailabilityReasonTypeValues returns the possible values for the InAvailabilityReasonType const type.
func PossibleInAvailabilityReasonTypeValues() []InAvailabilityReasonType {
	return []InAvailabilityReasonType{
		InAvailabilityReasonTypeAlreadyExists,
		InAvailabilityReasonTypeInvalid,
	}
}

// IngressTransportMethod - Ingress transport protocol
type IngressTransportMethod string

const (
	IngressTransportMethodAuto  IngressTransportMethod = "auto"
	IngressTransportMethodHTTP  IngressTransportMethod = "http"
	IngressTransportMethodHTTP2 IngressTransportMethod = "http2"
)

// PossibleIngressTransportMethodValues returns the possible values for the IngressTransportMethod const type.
func PossibleIngressTransportMethodValues() []IngressTransportMethod {
	return []IngressTransportMethod{
		IngressTransportMethodAuto,
		IngressTransportMethodHTTP,
		IngressTransportMethodHTTP2,
	}
}

// InsightStatus - Level of the most severe insight generated by the detector.
type InsightStatus string

const (
	InsightStatusCritical InsightStatus = "Critical"
	InsightStatusWarning  InsightStatus = "Warning"
	InsightStatusInfo     InsightStatus = "Info"
	InsightStatusSuccess  InsightStatus = "Success"
	InsightStatusNone     InsightStatus = "None"
)

// PossibleInsightStatusValues returns the possible values for the InsightStatus const type.
func PossibleInsightStatusValues() []InsightStatus {
	return []InsightStatus{
		InsightStatusCritical,
		InsightStatusWarning,
		InsightStatusInfo,
		InsightStatusSuccess,
		InsightStatusNone,
	}
}

// IssueType - Represents the type of the Detector
type IssueType string

const (
	IssueTypeServiceIncident      IssueType = "ServiceIncident"
	IssueTypeAppDeployment        IssueType = "AppDeployment"
	IssueTypeAppCrash             IssueType = "AppCrash"
	IssueTypeRuntimeIssueDetected IssueType = "RuntimeIssueDetected"
	IssueTypeAseDeployment        IssueType = "AseDeployment"
	IssueTypeUserIssue            IssueType = "UserIssue"
	IssueTypePlatformIssue        IssueType = "PlatformIssue"
	IssueTypeOther                IssueType = "Other"
)

// PossibleIssueTypeValues returns the possible values for the IssueType const type.
func PossibleIssueTypeValues() []IssueType {
	return []IssueType{
		IssueTypeServiceIncident,
		IssueTypeAppDeployment,
		IssueTypeAppCrash,
		IssueTypeRuntimeIssueDetected,
		IssueTypeAseDeployment,
		IssueTypeUserIssue,
		IssueTypePlatformIssue,
		IssueTypeOther,
	}
}

// KeyType - The key type.
type KeyType string

const (
	KeyTypeNotSpecified KeyType = "NotSpecified"
	KeyTypePrimary      KeyType = "Primary"
	KeyTypeSecondary    KeyType = "Secondary"
)

// PossibleKeyTypeValues returns the possible values for the KeyType const type.
func PossibleKeyTypeValues() []KeyType {
	return []KeyType{
		KeyTypeNotSpecified,
		KeyTypePrimary,
		KeyTypeSecondary,
	}
}

// KeyVaultSecretStatus - Status of the Key Vault secret.
type KeyVaultSecretStatus string

const (
	KeyVaultSecretStatusInitialized                              KeyVaultSecretStatus = "Initialized"
	KeyVaultSecretStatusWaitingOnCertificateOrder                KeyVaultSecretStatus = "WaitingOnCertificateOrder"
	KeyVaultSecretStatusSucceeded                                KeyVaultSecretStatus = "Succeeded"
	KeyVaultSecretStatusCertificateOrderFailed                   KeyVaultSecretStatus = "CertificateOrderFailed"
	KeyVaultSecretStatusOperationNotPermittedOnKeyVault          KeyVaultSecretStatus = "OperationNotPermittedOnKeyVault"
	KeyVaultSecretStatusAzureServiceUnauthorizedToAccessKeyVault KeyVaultSecretStatus = "AzureServiceUnauthorizedToAccessKeyVault"
	KeyVaultSecretStatusKeyVaultDoesNotExist                     KeyVaultSecretStatus = "KeyVaultDoesNotExist"
	KeyVaultSecretStatusKeyVaultSecretDoesNotExist               KeyVaultSecretStatus = "KeyVaultSecretDoesNotExist"
	KeyVaultSecretStatusUnknownError                             KeyVaultSecretStatus = "UnknownError"
	KeyVaultSecretStatusExternalPrivateKey                       KeyVaultSecretStatus = "ExternalPrivateKey"
	KeyVaultSecretStatusUnknown                                  KeyVaultSecretStatus = "Unknown"
)

// PossibleKeyVaultSecretStatusValues returns the possible values for the KeyVaultSecretStatus const type.
func PossibleKeyVaultSecretStatusValues() []KeyVaultSecretStatus {
	return []KeyVaultSecretStatus{
		KeyVaultSecretStatusInitialized,
		KeyVaultSecretStatusWaitingOnCertificateOrder,
		KeyVaultSecretStatusSucceeded,
		KeyVaultSecretStatusCertificateOrderFailed,
		KeyVaultSecretStatusOperationNotPermittedOnKeyVault,
		KeyVaultSecretStatusAzureServiceUnauthorizedToAccessKeyVault,
		KeyVaultSecretStatusKeyVaultDoesNotExist,
		KeyVaultSecretStatusKeyVaultSecretDoesNotExist,
		KeyVaultSecretStatusUnknownError,
		KeyVaultSecretStatusExternalPrivateKey,
		KeyVaultSecretStatusUnknown,
	}
}

// Kind - The workflow kind.
type Kind string

const (
	KindStateful  Kind = "Stateful"
	KindStateless Kind = "Stateless"
)

// PossibleKindValues returns the possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{
		KindStateful,
		KindStateless,
	}
}

// KubeEnvironmentProvisioningState - Provisioning state of the Kubernetes Environment.
type KubeEnvironmentProvisioningState string

const (
	KubeEnvironmentProvisioningStateSucceeded                     KubeEnvironmentProvisioningState = "Succeeded"
	KubeEnvironmentProvisioningStateFailed                        KubeEnvironmentProvisioningState = "Failed"
	KubeEnvironmentProvisioningStateCanceled                      KubeEnvironmentProvisioningState = "Canceled"
	KubeEnvironmentProvisioningStateWaiting                       KubeEnvironmentProvisioningState = "Waiting"
	KubeEnvironmentProvisioningStateInitializationInProgress      KubeEnvironmentProvisioningState = "InitializationInProgress"
	KubeEnvironmentProvisioningStateInfrastructureSetupInProgress KubeEnvironmentProvisioningState = "InfrastructureSetupInProgress"
	KubeEnvironmentProvisioningStateInfrastructureSetupComplete   KubeEnvironmentProvisioningState = "InfrastructureSetupComplete"
	KubeEnvironmentProvisioningStateScheduledForDelete            KubeEnvironmentProvisioningState = "ScheduledForDelete"
	KubeEnvironmentProvisioningStateUpgradeRequested              KubeEnvironmentProvisioningState = "UpgradeRequested"
	KubeEnvironmentProvisioningStateUpgradeFailed                 KubeEnvironmentProvisioningState = "UpgradeFailed"
)

// PossibleKubeEnvironmentProvisioningStateValues returns the possible values for the KubeEnvironmentProvisioningState const type.
func PossibleKubeEnvironmentProvisioningStateValues() []KubeEnvironmentProvisioningState {
	return []KubeEnvironmentProvisioningState{
		KubeEnvironmentProvisioningStateSucceeded,
		KubeEnvironmentProvisioningStateFailed,
		KubeEnvironmentProvisioningStateCanceled,
		KubeEnvironmentProvisioningStateWaiting,
		KubeEnvironmentProvisioningStateInitializationInProgress,
		KubeEnvironmentProvisioningStateInfrastructureSetupInProgress,
		KubeEnvironmentProvisioningStateInfrastructureSetupComplete,
		KubeEnvironmentProvisioningStateScheduledForDelete,
		KubeEnvironmentProvisioningStateUpgradeRequested,
		KubeEnvironmentProvisioningStateUpgradeFailed,
	}
}

// LoadBalancingMode - Specifies which endpoints to serve internally in the Virtual Network for the App Service Environment.
type LoadBalancingMode string

const (
	LoadBalancingModeNone          LoadBalancingMode = "None"
	LoadBalancingModePublishing    LoadBalancingMode = "Publishing"
	LoadBalancingModeWeb           LoadBalancingMode = "Web"
	LoadBalancingModeWebPublishing LoadBalancingMode = "Web, Publishing"
)

// PossibleLoadBalancingModeValues returns the possible values for the LoadBalancingMode const type.
func PossibleLoadBalancingModeValues() []LoadBalancingMode {
	return []LoadBalancingMode{
		LoadBalancingModeNone,
		LoadBalancingModePublishing,
		LoadBalancingModeWeb,
		LoadBalancingModeWebPublishing,
	}
}

// LogLevel - Log level.
type LogLevel string

const (
	LogLevelOff         LogLevel = "Off"
	LogLevelVerbose     LogLevel = "Verbose"
	LogLevelInformation LogLevel = "Information"
	LogLevelWarning     LogLevel = "Warning"
	LogLevelError       LogLevel = "Error"
)

// PossibleLogLevelValues returns the possible values for the LogLevel const type.
func PossibleLogLevelValues() []LogLevel {
	return []LogLevel{
		LogLevelOff,
		LogLevelVerbose,
		LogLevelInformation,
		LogLevelWarning,
		LogLevelError,
	}
}

// MSDeployLogEntryType - Log entry type
type MSDeployLogEntryType string

const (
	MSDeployLogEntryTypeMessage MSDeployLogEntryType = "Message"
	MSDeployLogEntryTypeWarning MSDeployLogEntryType = "Warning"
	MSDeployLogEntryTypeError   MSDeployLogEntryType = "Error"
)

// PossibleMSDeployLogEntryTypeValues returns the possible values for the MSDeployLogEntryType const type.
func PossibleMSDeployLogEntryTypeValues() []MSDeployLogEntryType {
	return []MSDeployLogEntryType{
		MSDeployLogEntryTypeMessage,
		MSDeployLogEntryTypeWarning,
		MSDeployLogEntryTypeError,
	}
}

// MSDeployProvisioningState - Provisioning state
type MSDeployProvisioningState string

const (
	MSDeployProvisioningStateAccepted  MSDeployProvisioningState = "accepted"
	MSDeployProvisioningStateRunning   MSDeployProvisioningState = "running"
	MSDeployProvisioningStateSucceeded MSDeployProvisioningState = "succeeded"
	MSDeployProvisioningStateFailed    MSDeployProvisioningState = "failed"
	MSDeployProvisioningStateCanceled  MSDeployProvisioningState = "canceled"
)

// PossibleMSDeployProvisioningStateValues returns the possible values for the MSDeployProvisioningState const type.
func PossibleMSDeployProvisioningStateValues() []MSDeployProvisioningState {
	return []MSDeployProvisioningState{
		MSDeployProvisioningStateAccepted,
		MSDeployProvisioningStateRunning,
		MSDeployProvisioningStateSucceeded,
		MSDeployProvisioningStateFailed,
		MSDeployProvisioningStateCanceled,
	}
}

// ManagedPipelineMode - Managed pipeline mode.
type ManagedPipelineMode string

const (
	ManagedPipelineModeIntegrated ManagedPipelineMode = "Integrated"
	ManagedPipelineModeClassic    ManagedPipelineMode = "Classic"
)

// PossibleManagedPipelineModeValues returns the possible values for the ManagedPipelineMode const type.
func PossibleManagedPipelineModeValues() []ManagedPipelineMode {
	return []ManagedPipelineMode{
		ManagedPipelineModeIntegrated,
		ManagedPipelineModeClassic,
	}
}

// ManagedServiceIdentityType - Type of managed service identity.
type ManagedServiceIdentityType string

const (
	ManagedServiceIdentityTypeSystemAssigned             ManagedServiceIdentityType = "SystemAssigned"
	ManagedServiceIdentityTypeUserAssigned               ManagedServiceIdentityType = "UserAssigned"
	ManagedServiceIdentityTypeSystemAssignedUserAssigned ManagedServiceIdentityType = "SystemAssigned, UserAssigned"
	ManagedServiceIdentityTypeNone                       ManagedServiceIdentityType = "None"
)

// PossibleManagedServiceIdentityTypeValues returns the possible values for the ManagedServiceIdentityType const type.
func PossibleManagedServiceIdentityTypeValues() []ManagedServiceIdentityType {
	return []ManagedServiceIdentityType{
		ManagedServiceIdentityTypeSystemAssigned,
		ManagedServiceIdentityTypeUserAssigned,
		ManagedServiceIdentityTypeSystemAssignedUserAssigned,
		ManagedServiceIdentityTypeNone,
	}
}

// MySQLMigrationType - The type of migration operation to be done
type MySQLMigrationType string

const (
	MySQLMigrationTypeLocalToRemote MySQLMigrationType = "LocalToRemote"
	MySQLMigrationTypeRemoteToLocal MySQLMigrationType = "RemoteToLocal"
)

// PossibleMySQLMigrationTypeValues returns the possible values for the MySQLMigrationType const type.
func PossibleMySQLMigrationTypeValues() []MySQLMigrationType {
	return []MySQLMigrationType{
		MySQLMigrationTypeLocalToRemote,
		MySQLMigrationTypeRemoteToLocal,
	}
}

// NotificationLevel - Level indicating how critical this recommendation can impact.
type NotificationLevel string

const (
	NotificationLevelCritical            NotificationLevel = "Critical"
	NotificationLevelWarning             NotificationLevel = "Warning"
	NotificationLevelInformation         NotificationLevel = "Information"
	NotificationLevelNonUrgentSuggestion NotificationLevel = "NonUrgentSuggestion"
)

// PossibleNotificationLevelValues returns the possible values for the NotificationLevel const type.
func PossibleNotificationLevelValues() []NotificationLevel {
	return []NotificationLevel{
		NotificationLevelCritical,
		NotificationLevelWarning,
		NotificationLevelInformation,
		NotificationLevelNonUrgentSuggestion,
	}
}

// OpenAuthenticationProviderType - Open authentication policy provider type.
type OpenAuthenticationProviderType string

const (
	OpenAuthenticationProviderTypeAAD OpenAuthenticationProviderType = "AAD"
)

// PossibleOpenAuthenticationProviderTypeValues returns the possible values for the OpenAuthenticationProviderType const type.
func PossibleOpenAuthenticationProviderTypeValues() []OpenAuthenticationProviderType {
	return []OpenAuthenticationProviderType{
		OpenAuthenticationProviderTypeAAD,
	}
}

// OperationStatus - The current status of the operation.
type OperationStatus string

const (
	OperationStatusInProgress OperationStatus = "InProgress"
	OperationStatusFailed     OperationStatus = "Failed"
	OperationStatusSucceeded  OperationStatus = "Succeeded"
	OperationStatusTimedOut   OperationStatus = "TimedOut"
	OperationStatusCreated    OperationStatus = "Created"
)

// PossibleOperationStatusValues returns the possible values for the OperationStatus const type.
func PossibleOperationStatusValues() []OperationStatus {
	return []OperationStatus{
		OperationStatusInProgress,
		OperationStatusFailed,
		OperationStatusSucceeded,
		OperationStatusTimedOut,
		OperationStatusCreated,
	}
}

// ParameterType - The parameter type.
type ParameterType string

const (
	ParameterTypeArray        ParameterType = "Array"
	ParameterTypeBool         ParameterType = "Bool"
	ParameterTypeFloat        ParameterType = "Float"
	ParameterTypeInt          ParameterType = "Int"
	ParameterTypeNotSpecified ParameterType = "NotSpecified"
	ParameterTypeObject       ParameterType = "Object"
	ParameterTypeSecureObject ParameterType = "SecureObject"
	ParameterTypeSecureString ParameterType = "SecureString"
	ParameterTypeString       ParameterType = "String"
)

// PossibleParameterTypeValues returns the possible values for the ParameterType const type.
func PossibleParameterTypeValues() []ParameterType {
	return []ParameterType{
		ParameterTypeArray,
		ParameterTypeBool,
		ParameterTypeFloat,
		ParameterTypeInt,
		ParameterTypeNotSpecified,
		ParameterTypeObject,
		ParameterTypeSecureObject,
		ParameterTypeSecureString,
		ParameterTypeString,
	}
}

type ProviderOsTypeSelected string

const (
	ProviderOsTypeSelectedAll              ProviderOsTypeSelected = "All"
	ProviderOsTypeSelectedLinux            ProviderOsTypeSelected = "Linux"
	ProviderOsTypeSelectedLinuxFunctions   ProviderOsTypeSelected = "LinuxFunctions"
	ProviderOsTypeSelectedWindows          ProviderOsTypeSelected = "Windows"
	ProviderOsTypeSelectedWindowsFunctions ProviderOsTypeSelected = "WindowsFunctions"
)

// PossibleProviderOsTypeSelectedValues returns the possible values for the ProviderOsTypeSelected const type.
func PossibleProviderOsTypeSelectedValues() []ProviderOsTypeSelected {
	return []ProviderOsTypeSelected{
		ProviderOsTypeSelectedAll,
		ProviderOsTypeSelectedLinux,
		ProviderOsTypeSelectedLinuxFunctions,
		ProviderOsTypeSelectedWindows,
		ProviderOsTypeSelectedWindowsFunctions,
	}
}

type ProviderStackOsType string

const (
	ProviderStackOsTypeAll     ProviderStackOsType = "All"
	ProviderStackOsTypeLinux   ProviderStackOsType = "Linux"
	ProviderStackOsTypeWindows ProviderStackOsType = "Windows"
)

// PossibleProviderStackOsTypeValues returns the possible values for the ProviderStackOsType const type.
func PossibleProviderStackOsTypeValues() []ProviderStackOsType {
	return []ProviderStackOsType{
		ProviderStackOsTypeAll,
		ProviderStackOsTypeLinux,
		ProviderStackOsTypeWindows,
	}
}

// ProvisioningState - Status of certificate order.
type ProvisioningState string

const (
	ProvisioningStateSucceeded  ProvisioningState = "Succeeded"
	ProvisioningStateFailed     ProvisioningState = "Failed"
	ProvisioningStateCanceled   ProvisioningState = "Canceled"
	ProvisioningStateInProgress ProvisioningState = "InProgress"
	ProvisioningStateDeleting   ProvisioningState = "Deleting"
)

// PossibleProvisioningStateValues returns the possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{
		ProvisioningStateSucceeded,
		ProvisioningStateFailed,
		ProvisioningStateCanceled,
		ProvisioningStateInProgress,
		ProvisioningStateDeleting,
	}
}

// PublicCertificateLocation - Public Certificate Location
type PublicCertificateLocation string

const (
	PublicCertificateLocationCurrentUserMy  PublicCertificateLocation = "CurrentUserMy"
	PublicCertificateLocationLocalMachineMy PublicCertificateLocation = "LocalMachineMy"
	PublicCertificateLocationUnknown        PublicCertificateLocation = "Unknown"
)

// PossiblePublicCertificateLocationValues returns the possible values for the PublicCertificateLocation const type.
func PossiblePublicCertificateLocationValues() []PublicCertificateLocation {
	return []PublicCertificateLocation{
		PublicCertificateLocationCurrentUserMy,
		PublicCertificateLocationLocalMachineMy,
		PublicCertificateLocationUnknown,
	}
}

// PublishingProfileFormat - Name of the format. Valid values are: FileZilla3 WebDeploy -- default Ftp
type PublishingProfileFormat string

const (
	PublishingProfileFormatFileZilla3 PublishingProfileFormat = "FileZilla3"
	PublishingProfileFormatFtp        PublishingProfileFormat = "Ftp"
	PublishingProfileFormatWebDeploy  PublishingProfileFormat = "WebDeploy"
)

// PossiblePublishingProfileFormatValues returns the possible values for the PublishingProfileFormat const type.
func PossiblePublishingProfileFormatValues() []PublishingProfileFormat {
	return []PublishingProfileFormat{
		PublishingProfileFormatFileZilla3,
		PublishingProfileFormatFtp,
		PublishingProfileFormatWebDeploy,
	}
}

// RecurrenceFrequency - The recurrence frequency.
type RecurrenceFrequency string

const (
	RecurrenceFrequencyDay          RecurrenceFrequency = "Day"
	RecurrenceFrequencyHour         RecurrenceFrequency = "Hour"
	RecurrenceFrequencyMinute       RecurrenceFrequency = "Minute"
	RecurrenceFrequencyMonth        RecurrenceFrequency = "Month"
	RecurrenceFrequencyNotSpecified RecurrenceFrequency = "NotSpecified"
	RecurrenceFrequencySecond       RecurrenceFrequency = "Second"
	RecurrenceFrequencyWeek         RecurrenceFrequency = "Week"
	RecurrenceFrequencyYear         RecurrenceFrequency = "Year"
)

// PossibleRecurrenceFrequencyValues returns the possible values for the RecurrenceFrequency const type.
func PossibleRecurrenceFrequencyValues() []RecurrenceFrequency {
	return []RecurrenceFrequency{
		RecurrenceFrequencyDay,
		RecurrenceFrequencyHour,
		RecurrenceFrequencyMinute,
		RecurrenceFrequencyMonth,
		RecurrenceFrequencyNotSpecified,
		RecurrenceFrequencySecond,
		RecurrenceFrequencyWeek,
		RecurrenceFrequencyYear,
	}
}

// RedundancyMode - Site redundancy mode
type RedundancyMode string

const (
	RedundancyModeNone         RedundancyMode = "None"
	RedundancyModeManual       RedundancyMode = "Manual"
	RedundancyModeFailover     RedundancyMode = "Failover"
	RedundancyModeActiveActive RedundancyMode = "ActiveActive"
	RedundancyModeGeoRedundant RedundancyMode = "GeoRedundant"
)

// PossibleRedundancyModeValues returns the possible values for the RedundancyMode const type.
func PossibleRedundancyModeValues() []RedundancyMode {
	return []RedundancyMode{
		RedundancyModeNone,
		RedundancyModeManual,
		RedundancyModeFailover,
		RedundancyModeActiveActive,
		RedundancyModeGeoRedundant,
	}
}

// RenderingType - Rendering Type
type RenderingType string

const (
	RenderingTypeNoGraph                  RenderingType = "NoGraph"
	RenderingTypeTable                    RenderingType = "Table"
	RenderingTypeTimeSeries               RenderingType = "TimeSeries"
	RenderingTypeTimeSeriesPerInstance    RenderingType = "TimeSeriesPerInstance"
	RenderingTypePieChart                 RenderingType = "PieChart"
	RenderingTypeDataSummary              RenderingType = "DataSummary"
	RenderingTypeEmail                    RenderingType = "Email"
	RenderingTypeInsights                 RenderingType = "Insights"
	RenderingTypeDynamicInsight           RenderingType = "DynamicInsight"
	RenderingTypeMarkdown                 RenderingType = "Markdown"
	RenderingTypeDetector                 RenderingType = "Detector"
	RenderingTypeDropDown                 RenderingType = "DropDown"
	RenderingTypeCard                     RenderingType = "Card"
	RenderingTypeSolution                 RenderingType = "Solution"
	RenderingTypeGuage                    RenderingType = "Guage"
	RenderingTypeForm                     RenderingType = "Form"
	RenderingTypeChangeSets               RenderingType = "ChangeSets"
	RenderingTypeChangeAnalysisOnboarding RenderingType = "ChangeAnalysisOnboarding"
	RenderingTypeChangesView              RenderingType = "ChangesView"
	RenderingTypeAppInsight               RenderingType = "AppInsight"
	RenderingTypeDependencyGraph          RenderingType = "DependencyGraph"
	RenderingTypeDownTime                 RenderingType = "DownTime"
	RenderingTypeSummaryCard              RenderingType = "SummaryCard"
	RenderingTypeSearchComponent          RenderingType = "SearchComponent"
	RenderingTypeAppInsightEnablement     RenderingType = "AppInsightEnablement"
)

// PossibleRenderingTypeValues returns the possible values for the RenderingType const type.
func PossibleRenderingTypeValues() []RenderingType {
	return []RenderingType{
		RenderingTypeNoGraph,
		RenderingTypeTable,
		RenderingTypeTimeSeries,
		RenderingTypeTimeSeriesPerInstance,
		RenderingTypePieChart,
		RenderingTypeDataSummary,
		RenderingTypeEmail,
		RenderingTypeInsights,
		RenderingTypeDynamicInsight,
		RenderingTypeMarkdown,
		RenderingTypeDetector,
		RenderingTypeDropDown,
		RenderingTypeCard,
		RenderingTypeSolution,
		RenderingTypeGuage,
		RenderingTypeForm,
		RenderingTypeChangeSets,
		RenderingTypeChangeAnalysisOnboarding,
		RenderingTypeChangesView,
		RenderingTypeAppInsight,
		RenderingTypeDependencyGraph,
		RenderingTypeDownTime,
		RenderingTypeSummaryCard,
		RenderingTypeSearchComponent,
		RenderingTypeAppInsightEnablement,
	}
}

type ResolveStatus string

const (
	ResolveStatusInitialized            ResolveStatus = "Initialized"
	ResolveStatusResolved               ResolveStatus = "Resolved"
	ResolveStatusInvalidSyntax          ResolveStatus = "InvalidSyntax"
	ResolveStatusMSINotEnabled          ResolveStatus = "MSINotEnabled"
	ResolveStatusVaultNotFound          ResolveStatus = "VaultNotFound"
	ResolveStatusSecretNotFound         ResolveStatus = "SecretNotFound"
	ResolveStatusSecretVersionNotFound  ResolveStatus = "SecretVersionNotFound"
	ResolveStatusAccessToKeyVaultDenied ResolveStatus = "AccessToKeyVaultDenied"
	ResolveStatusOtherReasons           ResolveStatus = "OtherReasons"
	ResolveStatusFetchTimedOut          ResolveStatus = "FetchTimedOut"
	ResolveStatusUnauthorizedClient     ResolveStatus = "UnauthorizedClient"
)

// PossibleResolveStatusValues returns the possible values for the ResolveStatus const type.
func PossibleResolveStatusValues() []ResolveStatus {
	return []ResolveStatus{
		ResolveStatusInitialized,
		ResolveStatusResolved,
		ResolveStatusInvalidSyntax,
		ResolveStatusMSINotEnabled,
		ResolveStatusVaultNotFound,
		ResolveStatusSecretNotFound,
		ResolveStatusSecretVersionNotFound,
		ResolveStatusAccessToKeyVaultDenied,
		ResolveStatusOtherReasons,
		ResolveStatusFetchTimedOut,
		ResolveStatusUnauthorizedClient,
	}
}

type ResourceNotRenewableReason string

const (
	ResourceNotRenewableReasonExpirationNotInRenewalTimeRange          ResourceNotRenewableReason = "ExpirationNotInRenewalTimeRange"
	ResourceNotRenewableReasonRegistrationStatusNotSupportedForRenewal ResourceNotRenewableReason = "RegistrationStatusNotSupportedForRenewal"
	ResourceNotRenewableReasonSubscriptionNotActive                    ResourceNotRenewableReason = "SubscriptionNotActive"
)

// PossibleResourceNotRenewableReasonValues returns the possible values for the ResourceNotRenewableReason const type.
func PossibleResourceNotRenewableReasonValues() []ResourceNotRenewableReason {
	return []ResourceNotRenewableReason{
		ResourceNotRenewableReasonExpirationNotInRenewalTimeRange,
		ResourceNotRenewableReasonRegistrationStatusNotSupportedForRenewal,
		ResourceNotRenewableReasonSubscriptionNotActive,
	}
}

// ResourceScopeType - Name of a resource type this recommendation applies, e.g. Subscription, ServerFarm, Site.
type ResourceScopeType string

const (
	ResourceScopeTypeServerFarm   ResourceScopeType = "ServerFarm"
	ResourceScopeTypeSubscription ResourceScopeType = "Subscription"
	ResourceScopeTypeWebSite      ResourceScopeType = "WebSite"
)

// PossibleResourceScopeTypeValues returns the possible values for the ResourceScopeType const type.
func PossibleResourceScopeTypeValues() []ResourceScopeType {
	return []ResourceScopeType{
		ResourceScopeTypeServerFarm,
		ResourceScopeTypeSubscription,
		ResourceScopeTypeWebSite,
	}
}

// RevisionHealthState - Current health State of the revision
type RevisionHealthState string

const (
	RevisionHealthStateHealthy   RevisionHealthState = "Healthy"
	RevisionHealthStateNone      RevisionHealthState = "None"
	RevisionHealthStateUnhealthy RevisionHealthState = "Unhealthy"
)

// PossibleRevisionHealthStateValues returns the possible values for the RevisionHealthState const type.
func PossibleRevisionHealthStateValues() []RevisionHealthState {
	return []RevisionHealthState{
		RevisionHealthStateHealthy,
		RevisionHealthStateNone,
		RevisionHealthStateUnhealthy,
	}
}

// RevisionProvisioningState - Current provisioning State of the revision
type RevisionProvisioningState string

const (
	RevisionProvisioningStateDeprovisioned  RevisionProvisioningState = "Deprovisioned"
	RevisionProvisioningStateDeprovisioning RevisionProvisioningState = "Deprovisioning"
	RevisionProvisioningStateFailed         RevisionProvisioningState = "Failed"
	RevisionProvisioningStateProvisioned    RevisionProvisioningState = "Provisioned"
	RevisionProvisioningStateProvisioning   RevisionProvisioningState = "Provisioning"
)

// PossibleRevisionProvisioningStateValues returns the possible values for the RevisionProvisioningState const type.
func PossibleRevisionProvisioningStateValues() []RevisionProvisioningState {
	return []RevisionProvisioningState{
		RevisionProvisioningStateDeprovisioned,
		RevisionProvisioningStateDeprovisioning,
		RevisionProvisioningStateFailed,
		RevisionProvisioningStateProvisioned,
		RevisionProvisioningStateProvisioning,
	}
}

// RouteType - The type of route this is: DEFAULT - By default, every app has routes to the local address ranges specified
// by RFC1918 INHERITED - Routes inherited from the real Virtual Network routes STATIC - Static
// route set on the app only
// These values will be used for syncing an app's routes with those from a Virtual Network.
type RouteType string

const (
	RouteTypeDEFAULT   RouteType = "DEFAULT"
	RouteTypeINHERITED RouteType = "INHERITED"
	RouteTypeSTATIC    RouteType = "STATIC"
)

// PossibleRouteTypeValues returns the possible values for the RouteType const type.
func PossibleRouteTypeValues() []RouteType {
	return []RouteType{
		RouteTypeDEFAULT,
		RouteTypeINHERITED,
		RouteTypeSTATIC,
	}
}

type SKUName string

const (
	SKUNameBasic            SKUName = "Basic"
	SKUNameDynamic          SKUName = "Dynamic"
	SKUNameElasticIsolated  SKUName = "ElasticIsolated"
	SKUNameElasticPremium   SKUName = "ElasticPremium"
	SKUNameFree             SKUName = "Free"
	SKUNameIsolated         SKUName = "Isolated"
	SKUNameIsolatedV2       SKUName = "IsolatedV2"
	SKUNamePremium          SKUName = "Premium"
	SKUNamePremiumContainer SKUName = "PremiumContainer"
	SKUNamePremiumV2        SKUName = "PremiumV2"
	SKUNamePremiumV3        SKUName = "PremiumV3"
	SKUNameShared           SKUName = "Shared"
	SKUNameStandard         SKUName = "Standard"
)

// PossibleSKUNameValues returns the possible values for the SKUName const type.
func PossibleSKUNameValues() []SKUName {
	return []SKUName{
		SKUNameBasic,
		SKUNameDynamic,
		SKUNameElasticIsolated,
		SKUNameElasticPremium,
		SKUNameFree,
		SKUNameIsolated,
		SKUNameIsolatedV2,
		SKUNamePremium,
		SKUNamePremiumContainer,
		SKUNamePremiumV2,
		SKUNamePremiumV3,
		SKUNameShared,
		SKUNameStandard,
	}
}

// SSLState - SSL type
type SSLState string

const (
	SSLStateDisabled       SSLState = "Disabled"
	SSLStateSniEnabled     SSLState = "SniEnabled"
	SSLStateIPBasedEnabled SSLState = "IpBasedEnabled"
)

// PossibleSSLStateValues returns the possible values for the SSLState const type.
func PossibleSSLStateValues() []SSLState {
	return []SSLState{
		SSLStateDisabled,
		SSLStateSniEnabled,
		SSLStateIPBasedEnabled,
	}
}

// ScmType - SCM type.
type ScmType string

const (
	ScmTypeBitbucketGit ScmType = "BitbucketGit"
	ScmTypeBitbucketHg  ScmType = "BitbucketHg"
	ScmTypeCodePlexGit  ScmType = "CodePlexGit"
	ScmTypeCodePlexHg   ScmType = "CodePlexHg"
	ScmTypeDropbox      ScmType = "Dropbox"
	ScmTypeExternalGit  ScmType = "ExternalGit"
	ScmTypeExternalHg   ScmType = "ExternalHg"
	ScmTypeGitHub       ScmType = "GitHub"
	ScmTypeLocalGit     ScmType = "LocalGit"
	ScmTypeNone         ScmType = "None"
	ScmTypeOneDrive     ScmType = "OneDrive"
	ScmTypeTfs          ScmType = "Tfs"
	ScmTypeVSO          ScmType = "VSO"
	ScmTypeVSTSRM       ScmType = "VSTSRM"
)

// PossibleScmTypeValues returns the possible values for the ScmType const type.
func PossibleScmTypeValues() []ScmType {
	return []ScmType{
		ScmTypeBitbucketGit,
		ScmTypeBitbucketHg,
		ScmTypeCodePlexGit,
		ScmTypeCodePlexHg,
		ScmTypeDropbox,
		ScmTypeExternalGit,
		ScmTypeExternalHg,
		ScmTypeGitHub,
		ScmTypeLocalGit,
		ScmTypeNone,
		ScmTypeOneDrive,
		ScmTypeTfs,
		ScmTypeVSO,
		ScmTypeVSTSRM,
	}
}

// SiteAvailabilityState - Management information availability state for the app.
type SiteAvailabilityState string

const (
	SiteAvailabilityStateNormal               SiteAvailabilityState = "Normal"
	SiteAvailabilityStateLimited              SiteAvailabilityState = "Limited"
	SiteAvailabilityStateDisasterRecoveryMode SiteAvailabilityState = "DisasterRecoveryMode"
)

// PossibleSiteAvailabilityStateValues returns the possible values for the SiteAvailabilityState const type.
func PossibleSiteAvailabilityStateValues() []SiteAvailabilityState {
	return []SiteAvailabilityState{
		SiteAvailabilityStateNormal,
		SiteAvailabilityStateLimited,
		SiteAvailabilityStateDisasterRecoveryMode,
	}
}

// SiteExtensionType - Site extension type.
type SiteExtensionType string

const (
	SiteExtensionTypeGallery SiteExtensionType = "Gallery"
	SiteExtensionTypeWebRoot SiteExtensionType = "WebRoot"
)

// PossibleSiteExtensionTypeValues returns the possible values for the SiteExtensionType const type.
func PossibleSiteExtensionTypeValues() []SiteExtensionType {
	return []SiteExtensionType{
		SiteExtensionTypeGallery,
		SiteExtensionTypeWebRoot,
	}
}

// SiteLoadBalancing - Site load balancing.
type SiteLoadBalancing string

const (
	SiteLoadBalancingWeightedRoundRobin   SiteLoadBalancing = "WeightedRoundRobin"
	SiteLoadBalancingLeastRequests        SiteLoadBalancing = "LeastRequests"
	SiteLoadBalancingLeastResponseTime    SiteLoadBalancing = "LeastResponseTime"
	SiteLoadBalancingWeightedTotalTraffic SiteLoadBalancing = "WeightedTotalTraffic"
	SiteLoadBalancingRequestHash          SiteLoadBalancing = "RequestHash"
	SiteLoadBalancingPerSiteRoundRobin    SiteLoadBalancing = "PerSiteRoundRobin"
)

// PossibleSiteLoadBalancingValues returns the possible values for the SiteLoadBalancing const type.
func PossibleSiteLoadBalancingValues() []SiteLoadBalancing {
	return []SiteLoadBalancing{
		SiteLoadBalancingWeightedRoundRobin,
		SiteLoadBalancingLeastRequests,
		SiteLoadBalancingLeastResponseTime,
		SiteLoadBalancingWeightedTotalTraffic,
		SiteLoadBalancingRequestHash,
		SiteLoadBalancingPerSiteRoundRobin,
	}
}

type SiteRuntimeState string

const (
	SiteRuntimeStateREADY   SiteRuntimeState = "READY"
	SiteRuntimeStateSTOPPED SiteRuntimeState = "STOPPED"
	SiteRuntimeStateUNKNOWN SiteRuntimeState = "UNKNOWN"
)

// PossibleSiteRuntimeStateValues returns the possible values for the SiteRuntimeState const type.
func PossibleSiteRuntimeStateValues() []SiteRuntimeState {
	return []SiteRuntimeState{
		SiteRuntimeStateREADY,
		SiteRuntimeStateSTOPPED,
		SiteRuntimeStateUNKNOWN,
	}
}

// SolutionType - Type of Solution
type SolutionType string

const (
	SolutionTypeQuickSolution     SolutionType = "QuickSolution"
	SolutionTypeDeepInvestigation SolutionType = "DeepInvestigation"
	SolutionTypeBestPractices     SolutionType = "BestPractices"
)

// PossibleSolutionTypeValues returns the possible values for the SolutionType const type.
func PossibleSolutionTypeValues() []SolutionType {
	return []SolutionType{
		SolutionTypeQuickSolution,
		SolutionTypeDeepInvestigation,
		SolutionTypeBestPractices,
	}
}

// StackPreferredOs - Function App stack preferred OS.
type StackPreferredOs string

const (
	StackPreferredOsWindows StackPreferredOs = "Windows"
	StackPreferredOsLinux   StackPreferredOs = "Linux"
)

// PossibleStackPreferredOsValues returns the possible values for the StackPreferredOs const type.
func PossibleStackPreferredOsValues() []StackPreferredOs {
	return []StackPreferredOs{
		StackPreferredOsWindows,
		StackPreferredOsLinux,
	}
}

// StagingEnvironmentPolicy - State indicating whether staging environments are allowed or not allowed for a static web app.
type StagingEnvironmentPolicy string

const (
	StagingEnvironmentPolicyEnabled  StagingEnvironmentPolicy = "Enabled"
	StagingEnvironmentPolicyDisabled StagingEnvironmentPolicy = "Disabled"
)

// PossibleStagingEnvironmentPolicyValues returns the possible values for the StagingEnvironmentPolicy const type.
func PossibleStagingEnvironmentPolicyValues() []StagingEnvironmentPolicy {
	return []StagingEnvironmentPolicy{
		StagingEnvironmentPolicyEnabled,
		StagingEnvironmentPolicyDisabled,
	}
}

// StatusOptions - App Service plan status.
type StatusOptions string

const (
	StatusOptionsReady    StatusOptions = "Ready"
	StatusOptionsPending  StatusOptions = "Pending"
	StatusOptionsCreating StatusOptions = "Creating"
)

// PossibleStatusOptionsValues returns the possible values for the StatusOptions const type.
func PossibleStatusOptionsValues() []StatusOptions {
	return []StatusOptions{
		StatusOptionsReady,
		StatusOptionsPending,
		StatusOptionsCreating,
	}
}

type StorageType string

const (
	StorageTypeLocalNode         StorageType = "LocalNode"
	StorageTypeNetworkFileSystem StorageType = "NetworkFileSystem"
)

// PossibleStorageTypeValues returns the possible values for the StorageType const type.
func PossibleStorageTypeValues() []StorageType {
	return []StorageType{
		StorageTypeLocalNode,
		StorageTypeNetworkFileSystem,
	}
}

// SupportedTLSVersions - MinTlsVersion: configures the minimum version of TLS required for SSL requests
type SupportedTLSVersions string

const (
	SupportedTLSVersionsOne0 SupportedTLSVersions = "1.0"
	SupportedTLSVersionsOne1 SupportedTLSVersions = "1.1"
	SupportedTLSVersionsOne2 SupportedTLSVersions = "1.2"
)

// PossibleSupportedTLSVersionsValues returns the possible values for the SupportedTLSVersions const type.
func PossibleSupportedTLSVersionsValues() []SupportedTLSVersions {
	return []SupportedTLSVersions{
		SupportedTLSVersionsOne0,
		SupportedTLSVersionsOne1,
		SupportedTLSVersionsOne2,
	}
}

// TriggerTypes - The trigger type of the function
type TriggerTypes string

const (
	TriggerTypesHTTPTrigger TriggerTypes = "HttpTrigger"
	TriggerTypesUnknown     TriggerTypes = "Unknown"
)

// PossibleTriggerTypesValues returns the possible values for the TriggerTypes const type.
func PossibleTriggerTypesValues() []TriggerTypes {
	return []TriggerTypes{
		TriggerTypesHTTPTrigger,
		TriggerTypesUnknown,
	}
}

// TriggeredWebJobStatus - Job status.
type TriggeredWebJobStatus string

const (
	TriggeredWebJobStatusSuccess TriggeredWebJobStatus = "Success"
	TriggeredWebJobStatusFailed  TriggeredWebJobStatus = "Failed"
	TriggeredWebJobStatusError   TriggeredWebJobStatus = "Error"
)

// PossibleTriggeredWebJobStatusValues returns the possible values for the TriggeredWebJobStatus const type.
func PossibleTriggeredWebJobStatusValues() []TriggeredWebJobStatus {
	return []TriggeredWebJobStatus{
		TriggeredWebJobStatusSuccess,
		TriggeredWebJobStatusFailed,
		TriggeredWebJobStatusError,
	}
}

// UnauthenticatedClientAction - The action to take when an unauthenticated client attempts to access the app.
type UnauthenticatedClientAction string

const (
	UnauthenticatedClientActionRedirectToLoginPage UnauthenticatedClientAction = "RedirectToLoginPage"
	UnauthenticatedClientActionAllowAnonymous      UnauthenticatedClientAction = "AllowAnonymous"
)

// PossibleUnauthenticatedClientActionValues returns the possible values for the UnauthenticatedClientAction const type.
func PossibleUnauthenticatedClientActionValues() []UnauthenticatedClientAction {
	return []UnauthenticatedClientAction{
		UnauthenticatedClientActionRedirectToLoginPage,
		UnauthenticatedClientActionAllowAnonymous,
	}
}

// UnauthenticatedClientActionV2 - The action to take when an unauthenticated client attempts to access the app.
type UnauthenticatedClientActionV2 string

const (
	UnauthenticatedClientActionV2RedirectToLoginPage UnauthenticatedClientActionV2 = "RedirectToLoginPage"
	UnauthenticatedClientActionV2AllowAnonymous      UnauthenticatedClientActionV2 = "AllowAnonymous"
	UnauthenticatedClientActionV2Return401           UnauthenticatedClientActionV2 = "Return401"
	UnauthenticatedClientActionV2Return403           UnauthenticatedClientActionV2 = "Return403"
)

// PossibleUnauthenticatedClientActionV2Values returns the possible values for the UnauthenticatedClientActionV2 const type.
func PossibleUnauthenticatedClientActionV2Values() []UnauthenticatedClientActionV2 {
	return []UnauthenticatedClientActionV2{
		UnauthenticatedClientActionV2RedirectToLoginPage,
		UnauthenticatedClientActionV2AllowAnonymous,
		UnauthenticatedClientActionV2Return401,
		UnauthenticatedClientActionV2Return403,
	}
}

// UpgradeAvailability - Whether an upgrade is available for this App Service Environment.
type UpgradeAvailability string

const (
	// UpgradeAvailabilityNone - No upgrade is currently available for this App Service Environment
	UpgradeAvailabilityNone UpgradeAvailability = "None"
	// UpgradeAvailabilityReady - An upgrade is ready to be manually initiated on this App Service Environment
	UpgradeAvailabilityReady UpgradeAvailability = "Ready"
)

// PossibleUpgradeAvailabilityValues returns the possible values for the UpgradeAvailability const type.
func PossibleUpgradeAvailabilityValues() []UpgradeAvailability {
	return []UpgradeAvailability{
		UpgradeAvailabilityNone,
		UpgradeAvailabilityReady,
	}
}

// UpgradePreference - Upgrade Preference
type UpgradePreference string

const (
	// UpgradePreferenceEarly - This App Service Environment will be upgraded before others in the same region that have Upgrade
	// Preference 'Late'
	UpgradePreferenceEarly UpgradePreference = "Early"
	// UpgradePreferenceLate - This App Service Environment will be upgraded after others in the same region that have Upgrade
	// Preference 'Early'
	UpgradePreferenceLate UpgradePreference = "Late"
	// UpgradePreferenceManual - ASEv3 only. Once an upgrade is available, this App Service Environment will wait 10 days for
	// the upgrade to be manually initiated. After 10 days the upgrade will begin automatically
	UpgradePreferenceManual UpgradePreference = "Manual"
	// UpgradePreferenceNone - No preference on when this App Service Environment will be upgraded
	UpgradePreferenceNone UpgradePreference = "None"
)

// PossibleUpgradePreferenceValues returns the possible values for the UpgradePreference const type.
func PossibleUpgradePreferenceValues() []UpgradePreference {
	return []UpgradePreference{
		UpgradePreferenceEarly,
		UpgradePreferenceLate,
		UpgradePreferenceManual,
		UpgradePreferenceNone,
	}
}

// UsageState - State indicating whether the app has exceeded its quota usage. Read-only.
type UsageState string

const (
	UsageStateNormal   UsageState = "Normal"
	UsageStateExceeded UsageState = "Exceeded"
)

// PossibleUsageStateValues returns the possible values for the UsageState const type.
func PossibleUsageStateValues() []UsageState {
	return []UsageState{
		UsageStateNormal,
		UsageStateExceeded,
	}
}

// ValidateResourceTypes - Resource type used for verification.
type ValidateResourceTypes string

const (
	ValidateResourceTypesMicrosoftWebHostingEnvironments ValidateResourceTypes = "Microsoft.Web/hostingEnvironments"
	ValidateResourceTypesServerFarm                      ValidateResourceTypes = "ServerFarm"
	ValidateResourceTypesSite                            ValidateResourceTypes = "Site"
)

// PossibleValidateResourceTypesValues returns the possible values for the ValidateResourceTypes const type.
func PossibleValidateResourceTypesValues() []ValidateResourceTypes {
	return []ValidateResourceTypes{
		ValidateResourceTypesMicrosoftWebHostingEnvironments,
		ValidateResourceTypesServerFarm,
		ValidateResourceTypesSite,
	}
}

// WebJobType - Job type.
type WebJobType string

const (
	WebJobTypeContinuous WebJobType = "Continuous"
	WebJobTypeTriggered  WebJobType = "Triggered"
)

// PossibleWebJobTypeValues returns the possible values for the WebJobType const type.
func PossibleWebJobTypeValues() []WebJobType {
	return []WebJobType{
		WebJobTypeContinuous,
		WebJobTypeTriggered,
	}
}

// WorkerSizeOptions - Size of the machines.
type WorkerSizeOptions string

const (
	WorkerSizeOptionsSmall            WorkerSizeOptions = "Small"
	WorkerSizeOptionsMedium           WorkerSizeOptions = "Medium"
	WorkerSizeOptionsLarge            WorkerSizeOptions = "Large"
	WorkerSizeOptionsD1               WorkerSizeOptions = "D1"
	WorkerSizeOptionsD2               WorkerSizeOptions = "D2"
	WorkerSizeOptionsD3               WorkerSizeOptions = "D3"
	WorkerSizeOptionsSmallV3          WorkerSizeOptions = "SmallV3"
	WorkerSizeOptionsMediumV3         WorkerSizeOptions = "MediumV3"
	WorkerSizeOptionsLargeV3          WorkerSizeOptions = "LargeV3"
	WorkerSizeOptionsNestedSmall      WorkerSizeOptions = "NestedSmall"
	WorkerSizeOptionsNestedSmallLinux WorkerSizeOptions = "NestedSmallLinux"
	WorkerSizeOptionsDefault          WorkerSizeOptions = "Default"
)

// PossibleWorkerSizeOptionsValues returns the possible values for the WorkerSizeOptions const type.
func PossibleWorkerSizeOptionsValues() []WorkerSizeOptions {
	return []WorkerSizeOptions{
		WorkerSizeOptionsSmall,
		WorkerSizeOptionsMedium,
		WorkerSizeOptionsLarge,
		WorkerSizeOptionsD1,
		WorkerSizeOptionsD2,
		WorkerSizeOptionsD3,
		WorkerSizeOptionsSmallV3,
		WorkerSizeOptionsMediumV3,
		WorkerSizeOptionsLargeV3,
		WorkerSizeOptionsNestedSmall,
		WorkerSizeOptionsNestedSmallLinux,
		WorkerSizeOptionsDefault,
	}
}

// WorkflowProvisioningState - The workflow provisioning state.
type WorkflowProvisioningState string

const (
	WorkflowProvisioningStateAccepted      WorkflowProvisioningState = "Accepted"
	WorkflowProvisioningStateCanceled      WorkflowProvisioningState = "Canceled"
	WorkflowProvisioningStateCompleted     WorkflowProvisioningState = "Completed"
	WorkflowProvisioningStateCreated       WorkflowProvisioningState = "Created"
	WorkflowProvisioningStateCreating      WorkflowProvisioningState = "Creating"
	WorkflowProvisioningStateDeleted       WorkflowProvisioningState = "Deleted"
	WorkflowProvisioningStateDeleting      WorkflowProvisioningState = "Deleting"
	WorkflowProvisioningStateFailed        WorkflowProvisioningState = "Failed"
	WorkflowProvisioningStateInProgress    WorkflowProvisioningState = "InProgress"
	WorkflowProvisioningStateMoving        WorkflowProvisioningState = "Moving"
	WorkflowProvisioningStateNotSpecified  WorkflowProvisioningState = "NotSpecified"
	WorkflowProvisioningStatePending       WorkflowProvisioningState = "Pending"
	WorkflowProvisioningStateReady         WorkflowProvisioningState = "Ready"
	WorkflowProvisioningStateRegistered    WorkflowProvisioningState = "Registered"
	WorkflowProvisioningStateRegistering   WorkflowProvisioningState = "Registering"
	WorkflowProvisioningStateRenewing      WorkflowProvisioningState = "Renewing"
	WorkflowProvisioningStateRunning       WorkflowProvisioningState = "Running"
	WorkflowProvisioningStateSucceeded     WorkflowProvisioningState = "Succeeded"
	WorkflowProvisioningStateUnregistered  WorkflowProvisioningState = "Unregistered"
	WorkflowProvisioningStateUnregistering WorkflowProvisioningState = "Unregistering"
	WorkflowProvisioningStateUpdating      WorkflowProvisioningState = "Updating"
	WorkflowProvisioningStateWaiting       WorkflowProvisioningState = "Waiting"
)

// PossibleWorkflowProvisioningStateValues returns the possible values for the WorkflowProvisioningState const type.
func PossibleWorkflowProvisioningStateValues() []WorkflowProvisioningState {
	return []WorkflowProvisioningState{
		WorkflowProvisioningStateAccepted,
		WorkflowProvisioningStateCanceled,
		WorkflowProvisioningStateCompleted,
		WorkflowProvisioningStateCreated,
		WorkflowProvisioningStateCreating,
		WorkflowProvisioningStateDeleted,
		WorkflowProvisioningStateDeleting,
		WorkflowProvisioningStateFailed,
		WorkflowProvisioningStateInProgress,
		WorkflowProvisioningStateMoving,
		WorkflowProvisioningStateNotSpecified,
		WorkflowProvisioningStatePending,
		WorkflowProvisioningStateReady,
		WorkflowProvisioningStateRegistered,
		WorkflowProvisioningStateRegistering,
		WorkflowProvisioningStateRenewing,
		WorkflowProvisioningStateRunning,
		WorkflowProvisioningStateSucceeded,
		WorkflowProvisioningStateUnregistered,
		WorkflowProvisioningStateUnregistering,
		WorkflowProvisioningStateUpdating,
		WorkflowProvisioningStateWaiting,
	}
}

// WorkflowSKUName - The sku name.
type WorkflowSKUName string

const (
	WorkflowSKUNameBasic        WorkflowSKUName = "Basic"
	WorkflowSKUNameFree         WorkflowSKUName = "Free"
	WorkflowSKUNameNotSpecified WorkflowSKUName = "NotSpecified"
	WorkflowSKUNamePremium      WorkflowSKUName = "Premium"
	WorkflowSKUNameShared       WorkflowSKUName = "Shared"
	WorkflowSKUNameStandard     WorkflowSKUName = "Standard"
)

// PossibleWorkflowSKUNameValues returns the possible values for the WorkflowSKUName const type.
func PossibleWorkflowSKUNameValues() []WorkflowSKUName {
	return []WorkflowSKUName{
		WorkflowSKUNameBasic,
		WorkflowSKUNameFree,
		WorkflowSKUNameNotSpecified,
		WorkflowSKUNamePremium,
		WorkflowSKUNameShared,
		WorkflowSKUNameStandard,
	}
}

// WorkflowState - The workflow state.
type WorkflowState string

const (
	WorkflowStateCompleted    WorkflowState = "Completed"
	WorkflowStateDeleted      WorkflowState = "Deleted"
	WorkflowStateDisabled     WorkflowState = "Disabled"
	WorkflowStateEnabled      WorkflowState = "Enabled"
	WorkflowStateNotSpecified WorkflowState = "NotSpecified"
	WorkflowStateSuspended    WorkflowState = "Suspended"
)

// PossibleWorkflowStateValues returns the possible values for the WorkflowState const type.
func PossibleWorkflowStateValues() []WorkflowState {
	return []WorkflowState{
		WorkflowStateCompleted,
		WorkflowStateDeleted,
		WorkflowStateDisabled,
		WorkflowStateEnabled,
		WorkflowStateNotSpecified,
		WorkflowStateSuspended,
	}
}

// WorkflowStatus - The workflow status.
type WorkflowStatus string

const (
	WorkflowStatusAborted      WorkflowStatus = "Aborted"
	WorkflowStatusCancelled    WorkflowStatus = "Cancelled"
	WorkflowStatusFailed       WorkflowStatus = "Failed"
	WorkflowStatusFaulted      WorkflowStatus = "Faulted"
	WorkflowStatusIgnored      WorkflowStatus = "Ignored"
	WorkflowStatusNotSpecified WorkflowStatus = "NotSpecified"
	WorkflowStatusPaused       WorkflowStatus = "Paused"
	WorkflowStatusRunning      WorkflowStatus = "Running"
	WorkflowStatusSkipped      WorkflowStatus = "Skipped"
	WorkflowStatusSucceeded    WorkflowStatus = "Succeeded"
	WorkflowStatusSuspended    WorkflowStatus = "Suspended"
	WorkflowStatusTimedOut     WorkflowStatus = "TimedOut"
	WorkflowStatusWaiting      WorkflowStatus = "Waiting"
)

// PossibleWorkflowStatusValues returns the possible values for the WorkflowStatus const type.
func PossibleWorkflowStatusValues() []WorkflowStatus {
	return []WorkflowStatus{
		WorkflowStatusAborted,
		WorkflowStatusCancelled,
		WorkflowStatusFailed,
		WorkflowStatusFaulted,
		WorkflowStatusIgnored,
		WorkflowStatusNotSpecified,
		WorkflowStatusPaused,
		WorkflowStatusRunning,
		WorkflowStatusSkipped,
		WorkflowStatusSucceeded,
		WorkflowStatusSuspended,
		WorkflowStatusTimedOut,
		WorkflowStatusWaiting,
	}
}

// WorkflowTriggerProvisioningState - The workflow trigger provisioning state.
type WorkflowTriggerProvisioningState string

const (
	WorkflowTriggerProvisioningStateAccepted      WorkflowTriggerProvisioningState = "Accepted"
	WorkflowTriggerProvisioningStateCanceled      WorkflowTriggerProvisioningState = "Canceled"
	WorkflowTriggerProvisioningStateCompleted     WorkflowTriggerProvisioningState = "Completed"
	WorkflowTriggerProvisioningStateCreated       WorkflowTriggerProvisioningState = "Created"
	WorkflowTriggerProvisioningStateCreating      WorkflowTriggerProvisioningState = "Creating"
	WorkflowTriggerProvisioningStateDeleted       WorkflowTriggerProvisioningState = "Deleted"
	WorkflowTriggerProvisioningStateDeleting      WorkflowTriggerProvisioningState = "Deleting"
	WorkflowTriggerProvisioningStateFailed        WorkflowTriggerProvisioningState = "Failed"
	WorkflowTriggerProvisioningStateMoving        WorkflowTriggerProvisioningState = "Moving"
	WorkflowTriggerProvisioningStateNotSpecified  WorkflowTriggerProvisioningState = "NotSpecified"
	WorkflowTriggerProvisioningStateReady         WorkflowTriggerProvisioningState = "Ready"
	WorkflowTriggerProvisioningStateRegistered    WorkflowTriggerProvisioningState = "Registered"
	WorkflowTriggerProvisioningStateRegistering   WorkflowTriggerProvisioningState = "Registering"
	WorkflowTriggerProvisioningStateRunning       WorkflowTriggerProvisioningState = "Running"
	WorkflowTriggerProvisioningStateSucceeded     WorkflowTriggerProvisioningState = "Succeeded"
	WorkflowTriggerProvisioningStateUnregistered  WorkflowTriggerProvisioningState = "Unregistered"
	WorkflowTriggerProvisioningStateUnregistering WorkflowTriggerProvisioningState = "Unregistering"
	WorkflowTriggerProvisioningStateUpdating      WorkflowTriggerProvisioningState = "Updating"
)

// PossibleWorkflowTriggerProvisioningStateValues returns the possible values for the WorkflowTriggerProvisioningState const type.
func PossibleWorkflowTriggerProvisioningStateValues() []WorkflowTriggerProvisioningState {
	return []WorkflowTriggerProvisioningState{
		WorkflowTriggerProvisioningStateAccepted,
		WorkflowTriggerProvisioningStateCanceled,
		WorkflowTriggerProvisioningStateCompleted,
		WorkflowTriggerProvisioningStateCreated,
		WorkflowTriggerProvisioningStateCreating,
		WorkflowTriggerProvisioningStateDeleted,
		WorkflowTriggerProvisioningStateDeleting,
		WorkflowTriggerProvisioningStateFailed,
		WorkflowTriggerProvisioningStateMoving,
		WorkflowTriggerProvisioningStateNotSpecified,
		WorkflowTriggerProvisioningStateReady,
		WorkflowTriggerProvisioningStateRegistered,
		WorkflowTriggerProvisioningStateRegistering,
		WorkflowTriggerProvisioningStateRunning,
		WorkflowTriggerProvisioningStateSucceeded,
		WorkflowTriggerProvisioningStateUnregistered,
		WorkflowTriggerProvisioningStateUnregistering,
		WorkflowTriggerProvisioningStateUpdating,
	}
}
