#! /bin/sh
# Copyright (c) 2023 Meta Platforms, Inc. and affiliates.
# This file is part of elfutils.
#
# This file is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# elfutils is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

. $srcdir/test-subr.sh

# See testfile-dwp.source.
testfiles testfile-dwp-5.dwp testfile-dwp-4.dwp testfile-dwp-4-strict.dwp

testrun_compare ${abs_builddir}/cu-dwp-section-info testfile-dwp-5.dwp << EOF
file: testfile-dwp-5.dwp
INFO: 0x0 0x70
TYPES: 0x0 0x0
ABBREV: 0x0 0x160
LINE: 0x0 0x7f
LOCLISTS: 0x0 0xdb
STR_OFFSETS: 0x0 0x75c
MACRO: 0x0 0x6c6
RNGLISTS: 0x0 0x22

INFO: 0x70 0x108
TYPES: 0x0 0x0
ABBREV: 0x0 0x160
LINE: 0x0 0x7f
LOCLISTS: 0x0 0xdb
STR_OFFSETS: 0x0 0x75c
MACRO: 0x0 0x6c6
RNGLISTS: 0x0 0x22

INFO: 0x178 0x6e
TYPES: 0x0 0x0
ABBREV: 0x160 0xca
LINE: 0x7f 0x7f
LOCLISTS: 0x0 0x0
STR_OFFSETS: 0x75c 0x758
MACRO: 0x6c6 0x6c5
RNGLISTS: 0x0 0x0

INFO: 0x1e6 0x78
TYPES: 0x0 0x0
ABBREV: 0x160 0xca
LINE: 0x7f 0x7f
LOCLISTS: 0x0 0x0
STR_OFFSETS: 0x75c 0x758
MACRO: 0x6c6 0x6c5
RNGLISTS: 0x0 0x0

INFO: 0x25e 0x193
TYPES: 0x0 0x0
ABBREV: 0x22a 0x18a
LINE: 0xfe 0x81
LOCLISTS: 0xdb 0xc9
STR_OFFSETS: 0xeb4 0x77c
MACRO: 0xd8b 0x6c6
RNGLISTS: 0x22 0x43

EOF

testrun_compare ${abs_builddir}/cu-dwp-section-info testfile-dwp-4.dwp << EOF
file: testfile-dwp-4.dwp
INFO: 0x0 0x11e
TYPES: 0x0 0x0
ABBREV: 0x0 0x172
LINE: 0x0 0x52
LOCLISTS: 0x0 0x11b
STR_OFFSETS: 0x0 0x754
MACRO: 0x0 0x6c7
RNGLISTS: 0x0 0x0

INFO: 0x11e 0x76
TYPES: 0x0 0x0
ABBREV: 0x172 0xd7
LINE: 0x52 0x52
LOCLISTS: 0x0 0x0
STR_OFFSETS: 0x754 0x750
MACRO: 0x6c7 0x6c6
RNGLISTS: 0x0 0x0

INFO: 0x194 0x1c5
TYPES: 0x0 0x0
ABBREV: 0x249 0x19e
LINE: 0xa4 0x53
LOCLISTS: 0x11b 0xf1
STR_OFFSETS: 0xea4 0x774
MACRO: 0xd8d 0x6c7
RNGLISTS: 0x0 0x0

INFO: 0x0 0x0
TYPES: 0x0 0x6f
ABBREV: 0x0 0x172
LINE: 0x0 0x52
LOCLISTS: 0x0 0x11b
STR_OFFSETS: 0x0 0x754
MACRO: 0x0 0x6c7
RNGLISTS: 0x0 0x0

INFO: 0x0 0x0
TYPES: 0x6f 0x6d
ABBREV: 0x172 0xd7
LINE: 0x52 0x52
LOCLISTS: 0x0 0x0
STR_OFFSETS: 0x754 0x750
MACRO: 0x6c7 0x6c6
RNGLISTS: 0x0 0x0

EOF

testrun_compare ${abs_builddir}/cu-dwp-section-info testfile-dwp-4-strict.dwp << EOF
file: testfile-dwp-4-strict.dwp
INFO: 0x0 0x105
TYPES: 0x0 0x0
ABBREV: 0x0 0x15f
LINE: 0x0 0x52
LOCLISTS: 0x0 0xe2
STR_OFFSETS: 0x0 0x24
MACRO: 0x0 0x38e4
RNGLISTS: 0x0 0x0

INFO: 0x105 0x72
TYPES: 0x0 0x0
ABBREV: 0x15f 0xd3
LINE: 0x52 0x52
LOCLISTS: 0x0 0x0
STR_OFFSETS: 0x24 0x20
MACRO: 0x38e4 0x38db
RNGLISTS: 0x0 0x0

INFO: 0x177 0x17b
TYPES: 0x0 0x0
ABBREV: 0x232 0x157
LINE: 0xa4 0x53
LOCLISTS: 0xe2 0xb1
STR_OFFSETS: 0x44 0x44
MACRO: 0x71bf 0x38f5
RNGLISTS: 0x0 0x0

INFO: 0x0 0x0
TYPES: 0x0 0x6e
ABBREV: 0x0 0x15f
LINE: 0x0 0x52
LOCLISTS: 0x0 0xe2
STR_OFFSETS: 0x0 0x24
MACRO: 0x0 0x38e4
RNGLISTS: 0x0 0x0

INFO: 0x0 0x0
TYPES: 0x6e 0x6b
ABBREV: 0x15f 0xd3
LINE: 0x52 0x52
LOCLISTS: 0x0 0x0
STR_OFFSETS: 0x24 0x20
MACRO: 0x38e4 0x38db
RNGLISTS: 0x0 0x0

EOF
