# containerd roadmap

containerd uses the issues and milestones to define its roadmap.
`ROADMAP.md` files are common in open source projects but we find they quickly become out of date.
We opt for an issues and milestone approach that our maintainers and community can keep up-to-date as work is added and completed.

## Issues

Issues tagged with the `roadmap` label are high level roadmap items.
They are tasks and/or features that the containerd community wants completed.

Smaller issues and pull requests can reference back to the main roadmap issue that is tagged to help detail progress towards the overall goal.

## Milestones

Milestones define when an issue, pull request, and/or roadmap item is to be completed.
Issues are the what, milestones are the when.
Development is complex therefore roadmap items can move between milestones depending on the remaining development and testing required to release a change.

## Searching

To find the roadmap items currently planned for containerd you can filter on the `roadmap` label.

[Search Roadmap Items](https://github.com/containerd/containerd/issues?q=is%3Aopen+is%3Aissue+label%3Aroadmap)

After searching for roadmap items you can view what milestone they are scheduled to be completed in along with the progress.

[View Milestones](https://github.com/containerd/containerd/milestones)
