# Contributing Guidelines

Before contributing to Capirca please take into mind the following.

## Contributors License Agreements

We require everyone who submits code to us to sign the
[Contributors License Agreement](https://cla.developers.google.com/clas).
Please take the time to sign this before sending us a Pull Request.

## Code Readability

Please take time to become familiar with the
[Google Python Style Guide](https://google.github.io/styleguide/pyguide.html).
We try to adhere to the rules in the guide as much as possible. To help with
that you can use our
[lint tool](https://github.com/google/capirca/blob/master/tools/run_lint.sh).
This runs pylint over the files and will display new lint errors. This will
not catch certain style choices but it will find a majority of problems that
are easy to fix. If you feel a lint error is incorrect let us know and we can
suppress it.

## Development Environment

Run the following script to install `capirca` in development environment.

```bash
dev-install
```
