/*
 *  acm : an aerial combat simulator for X
 *  Copyright (C) 1991-1998  Riley Rainey
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 dated June, 1991.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program;  if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
 */

#ifndef sounds_h
#define sounds_h

#include "pm.h"

#ifdef sounds_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

/**
 *  Pre-defined sound IDs.
 */
typedef enum {
	sounds_None = -1,
	sounds_NoEngine,
	sounds_GenericPistonEngine,
	sounds_GenericJetEngine,
	sounds_GenericRocketEngine,
	sounds_Crash,
	sounds_GearUp,
	sounds_GearDown,
	sounds_MissileLaunch,
	sounds_CannonFiring,
	sounds_Explosion,
	sounds_Touchdown,
	sounds_GenericWarning,
	sounds_StallWarning,
	sounds_LockWarning,
	sounds_APGLockAcquired,
	sounds_NumberOfSounds // Gives the total number of defined sounds.
} sounds_SoundID;

/**
 * Enables or disables sounds playing. When enabled the first time, a sounds
 * data structure is attached to the "sounds" field of the viewer of the aircraft;
 * this field must be released along with the viewer using memory_dispose().
 * @param status True to enable sounds, false to mute.
 */
EXTERN void sounds_enable(craft * c, int enable);

/**
 * Returns true if allowed to play sounds, false if muted.
 */
EXTERN int sounds_isEnabled(craft * c);

/**
 * 
 * Sets the engine background sound on all the viewers of this plane.
 * @param c
 * @param rpm_rate RPM rate in [0,1].
 * @param afterburner Afterburner enabled.
 * @param dDynamicPressure IGNORED.
 */
EXTERN void sounds_setBackgroundSound(craft * c, double rpm_rate,
	int afterburner, double dynamicPressure);

/**
 * Play a sound one time or continously on all the viewers of this plane.
 * @param c
 * @param id
 * @param loop
 */
EXTERN void sounds_playSound(craft * c, sounds_SoundID id, int loop);

/**
 * Stop the execution of the sound started by playSound on all the viewers of
 * that plane.
 * @param c
 * @param id
 */
EXTERN void sounds_stopSound(craft * c, sounds_SoundID id);

/**
 * To be called continously to update the audio.
 */
EXTERN void sounds_update(craft * c);

#undef EXTERN
#endif
